/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.hash;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.security.bcrypt.BCrypt;
import com.helger.security.password.hash.AbstractPasswordHashCreator;
import com.helger.security.password.salt.IPasswordSalt;
import com.helger.security.password.salt.PasswordSaltBCrypt;
import org.jspecify.annotations.NonNull;

public final class PasswordHashCreatorBCrypt
extends AbstractPasswordHashCreator {
    public static final String ALGORITHM = "BCrypt";

    public PasswordHashCreatorBCrypt() {
        super(ALGORITHM);
    }

    @Override
    public boolean requiresSalt() {
        return true;
    }

    @Override
    public @NonNull String createPasswordHash(@NonNull IPasswordSalt iPasswordSalt, @NonNull String string) {
        ValueEnforcer.notNull((Object)iPasswordSalt, (String)"Salt");
        ValueEnforcer.isInstanceOf((Object)iPasswordSalt, PasswordSaltBCrypt.class, (String)"Salt");
        ValueEnforcer.notNull((Object)string, (String)"PlainTextPassword");
        return BCrypt.hashpw(string, iPasswordSalt.getSaltString());
    }
}

