/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreAndKeyDescriptor;
import java.security.Provider;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class KeyStoreAndKeyDescriptorBuilder
implements IBuilder<KeyStoreAndKeyDescriptor> {
    private IKeyStoreType m_aType;
    private String m_sPath;
    private char[] m_aPassword;
    private Provider m_aProvider;
    private String m_sKeyAlias;
    private char[] m_aKeyPassword;

    public KeyStoreAndKeyDescriptorBuilder() {
    }

    public KeyStoreAndKeyDescriptorBuilder(@NonNull KeyStoreAndKeyDescriptor keyStoreAndKeyDescriptor) {
        ValueEnforcer.notNull((Object)keyStoreAndKeyDescriptor, (String)"SourceKeyStoreAndKeyDescriptor");
        this.type(keyStoreAndKeyDescriptor.m_aType).path(keyStoreAndKeyDescriptor.m_sPath).password(keyStoreAndKeyDescriptor.m_aPassword).provider(keyStoreAndKeyDescriptor.m_aProvider).keyAlias(keyStoreAndKeyDescriptor.m_sKeyAlias).keyPassword(keyStoreAndKeyDescriptor.m_aKeyPassword);
    }

    public final @NonNull KeyStoreAndKeyDescriptorBuilder type(@Nullable IKeyStoreType iKeyStoreType) {
        this.m_aType = iKeyStoreType;
        return this;
    }

    public final @NonNull KeyStoreAndKeyDescriptorBuilder path(@Nullable String string) {
        this.m_sPath = string;
        return this;
    }

    public final @NonNull KeyStoreAndKeyDescriptorBuilder password(@Nullable String string) {
        return this.password(string == null ? null : string.toCharArray());
    }

    public final @NonNull KeyStoreAndKeyDescriptorBuilder password(char @Nullable [] cArray) {
        this.m_aPassword = cArray;
        return this;
    }

    public final @NonNull KeyStoreAndKeyDescriptorBuilder provider(@Nullable Provider provider) {
        this.m_aProvider = provider;
        return this;
    }

    public final @NonNull KeyStoreAndKeyDescriptorBuilder keyAlias(@Nullable String string) {
        this.m_sKeyAlias = string;
        return this;
    }

    public final @NonNull KeyStoreAndKeyDescriptorBuilder keyPassword(@Nullable String string) {
        return this.keyPassword(string == null ? null : string.toCharArray());
    }

    public final @NonNull KeyStoreAndKeyDescriptorBuilder keyPassword(char @Nullable [] cArray) {
        this.m_aKeyPassword = cArray;
        return this;
    }

    public @NonNull KeyStoreAndKeyDescriptor build() throws IllegalStateException {
        if (this.m_aType == null) {
            throw new IllegalStateException("Type is missing");
        }
        if (StringHelper.isEmpty((String)this.m_sPath)) {
            throw new IllegalStateException("Path is empty");
        }
        if (this.m_aPassword == null) {
            throw new IllegalStateException("Password is missing");
        }
        if (StringHelper.isEmpty((String)this.m_sKeyAlias)) {
            throw new IllegalStateException("KeyAlias is empty");
        }
        if (this.m_aKeyPassword == null) {
            throw new IllegalStateException("KeyPassword is missing");
        }
        return new KeyStoreAndKeyDescriptor(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider, this.m_sKeyAlias, this.m_aKeyPassword);
    }
}

