/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.certificate;

import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.stream.StringInputStream;
import com.helger.security.certificate.CertificateHelper;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CertificateDecodeHelper {
    public static final boolean DEFAULT_PEM_ENCODED = false;
    private byte[] m_aSrcBytes;
    private String m_sSrcString;
    private boolean m_bPEMEncoded = false;

    public @NonNull CertificateDecodeHelper source(byte @Nullable [] byArray) {
        this.m_aSrcBytes = byArray;
        this.m_sSrcString = null;
        return this;
    }

    public @NonNull CertificateDecodeHelper source(@Nullable String string) {
        this.m_aSrcBytes = null;
        this.m_sSrcString = string;
        return this;
    }

    public @NonNull CertificateDecodeHelper pemEncoded(boolean bl) {
        this.m_bPEMEncoded = bl;
        return this;
    }

    public @Nullable X509Certificate getDecodedOrThrow() throws CertificateException {
        if (this.m_aSrcBytes == null && this.m_sSrcString == null) {
            return null;
        }
        if (this.m_bPEMEncoded) {
            String string = (this.m_sSrcString != null ? this.m_sSrcString : new String(this.m_aSrcBytes, CertificateHelper.CERT_CHARSET)).trim();
            if (!string.isEmpty()) {
                CertificateFactory certificateFactory = CertificateHelper.getX509CertificateFactory();
                String string2 = CertificateHelper.getRFC1421CompliantString(string, true);
                try (StringInputStream stringInputStream = new StringInputStream(string2, CertificateHelper.CERT_CHARSET);){
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)stringInputStream);
                    return x509Certificate;
                }
            }
        } else {
            byte[] byArray;
            byte[] byArray2 = byArray = this.m_aSrcBytes != null ? this.m_aSrcBytes : this.m_sSrcString.trim().getBytes(CertificateHelper.CERT_CHARSET);
            if (byArray.length > 0) {
                CertificateFactory certificateFactory = CertificateHelper.getX509CertificateFactory();
                try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);){
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)nonBlockingByteArrayInputStream);
                    return x509Certificate;
                }
            }
        }
        return null;
    }

    public @Nullable X509Certificate getDecodedOrNull() {
        try {
            return this.getDecodedOrThrow();
        }
        catch (IllegalArgumentException | CertificateException exception) {
            return null;
        }
    }
}

