/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.hash;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHex;
import com.helger.security.password.hash.AbstractPasswordHashCreator;
import com.helger.security.password.salt.IPasswordSalt;
import jakarta.annotation.Nonnull;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public abstract class AbstractPasswordHashCreatorPBKDF2
extends AbstractPasswordHashCreator {
    protected final String m_sPBKDF2AlgorithmName;
    protected final int m_nIterations;
    protected final int m_nHashBytes;

    protected AbstractPasswordHashCreatorPBKDF2(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnegative int n, @Nonnegative int n2) {
        super(string);
        this.m_sPBKDF2AlgorithmName = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"PBKDF2AlgorithmName");
        this.m_nIterations = ValueEnforcer.isGT0((int)n, (String)"Iterations");
        this.m_nHashBytes = ValueEnforcer.isGT0((int)n2, (String)"Bytes");
    }

    @Override
    public final boolean requiresSalt() {
        return true;
    }

    @Nonnull
    protected static final byte[] pbkdf2(@Nonnull char[] cArray, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty String string) {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, n, n2 * 8);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
            return secretKeyFactory.generateSecret(pBEKeySpec).getEncoded();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Failed to apply PBKDF2 algorithm '" + string + "' with " + n + " iterations and " + n2 + " bytes", generalSecurityException);
        }
    }

    @Override
    @Nonnull
    public String createPasswordHash(@Nonnull IPasswordSalt iPasswordSalt, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iPasswordSalt, (String)"Salt");
        ValueEnforcer.notNull((Object)string, (String)"PlainTextPassword");
        byte[] byArray = AbstractPasswordHashCreatorPBKDF2.pbkdf2(string.toCharArray(), iPasswordSalt.getSaltBytes(), this.m_nIterations, this.m_nHashBytes, this.m_sPBKDF2AlgorithmName);
        return StringHex.getHexEncoded((byte[])byArray);
    }
}

