/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.security.authentication.result.AuthToken;
import com.helger.security.authentication.result.IAuthIdentification;
import com.helger.security.authentication.result.IAuthToken;
import com.helger.security.authentication.subject.IAuthSubject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@ThreadSafe
public final class AuthTokenRegistry {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static final ICommonsMap<String, AuthToken> MAP = new CommonsHashMap();

    private AuthTokenRegistry() {
    }

    @Nonnull
    public static IAuthToken createToken(@Nonnull IAuthIdentification iAuthIdentification, @Nonnegative int n) {
        AuthToken authToken = new AuthToken(iAuthIdentification, n);
        String string = authToken.getID();
        RW_LOCK.writeLocked(() -> {
            if (MAP.containsKey((Object)string)) {
                throw new IllegalArgumentException("Token '" + string + "' already contained");
            }
            MAP.put((Object)string, (Object)authToken);
        });
        return authToken;
    }

    @Nonnull
    public static ESuccess removeToken(@Nonnull String string) {
        return (ESuccess)RW_LOCK.writeLockedGet(() -> {
            AuthToken authToken = (AuthToken)MAP.remove((Object)string);
            if (authToken == null) {
                return ESuccess.FAILURE;
            }
            authToken.setExpired();
            return ESuccess.SUCCESS;
        });
    }

    @Nullable
    private static AuthToken _getValidNotExpiredToken(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        AuthToken authToken = (AuthToken)RW_LOCK.readLockedGet(() -> (AuthToken)MAP.get((Object)string));
        return authToken != null && !authToken.isExpired() ? authToken : null;
    }

    @Nullable
    public static IAuthToken getValidToken(@Nullable String string) {
        return AuthTokenRegistry._getValidNotExpiredToken(string);
    }

    @Nullable
    public static IAuthToken validateTokenAndUpdateLastAccess(@Nullable String string) {
        AuthToken authToken = AuthTokenRegistry._getValidNotExpiredToken(string);
        if (authToken == null) {
            return null;
        }
        RW_LOCK.writeLocked(authToken::updateLastAccess);
        return authToken;
    }

    @Nonnull
    public static ICommonsList<IAuthToken> getAllTokensOfSubject(@Nonnull IAuthSubject iAuthSubject) {
        ValueEnforcer.notNull((Object)iAuthSubject, (String)"Subject");
        return (ICommonsList)RW_LOCK.readLockedGet(() -> CommonsArrayList.createFiltered((Iterable)MAP.values(), iAuthToken -> iAuthToken.getIdentification().hasAuthSubject(iAuthSubject)));
    }

    @Nonnegative
    public static int removeAllTokensOfSubject(@Nonnull IAuthSubject iAuthSubject) {
        ValueEnforcer.notNull((Object)iAuthSubject, (String)"Subject");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        RW_LOCK.readLocked(() -> AuthTokenRegistry.lambda$removeAllTokensOfSubject$5(iAuthSubject, (ICommonsList)commonsArrayList));
        for (String string : commonsArrayList) {
            AuthTokenRegistry.removeToken(string);
        }
        return commonsArrayList.size();
    }

    private static /* synthetic */ void lambda$removeAllTokensOfSubject$5(IAuthSubject iAuthSubject, ICommonsList iCommonsList) {
        for (Map.Entry entry : MAP.entrySet()) {
            if (!((AuthToken)entry.getValue()).getIdentification().hasAuthSubject(iAuthSubject)) continue;
            iCommonsList.add((Object)((String)entry.getKey()));
        }
    }
}

