/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.crl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.impl.Cache;
import com.helger.datetime.expiration.ExpiringObject;
import com.helger.security.crl.CRLDownloader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.cert.CRL;
import java.time.Duration;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLCache {
    public static final Duration DEFAULT_CACHING_DURATION = Duration.ofHours(24L);
    private static final Logger LOGGER = LoggerFactory.getLogger(CRLCache.class);
    private final CRLInternalCache m_aCache;
    private final CRLDownloader m_aDownloader;
    private final Duration m_aCachingDuration;

    public CRLCache(@Nonnull CRLDownloader cRLDownloader, @Nonnull Duration duration) {
        ValueEnforcer.notNull((Object)cRLDownloader, (String)"CRLDownloader");
        ValueEnforcer.notNull((Object)duration, (String)"CachingDuration");
        ValueEnforcer.isFalse(duration::isNegative, (String)"CachingDuration must not be negative");
        this.m_aCache = new CRLInternalCache(string -> {
            CRL cRL = cRLDownloader.downloadCRL((String)string);
            return cRL == null ? null : ExpiringObject.ofDuration((Object)cRL, (Duration)duration);
        }, 200, "CRLCache", true);
        this.m_aDownloader = cRLDownloader;
        this.m_aCachingDuration = duration;
    }

    @Nonnull
    public final CRLDownloader getDownloader() {
        return this.m_aDownloader;
    }

    @Nonnull
    public final Duration getCachingDuration() {
        return this.m_aCachingDuration;
    }

    @Nullable
    public CRL getCRLFromURL(@Nullable String string) {
        ExpiringObject expiringObject;
        if (StringHelper.isNotEmpty((String)string) && (expiringObject = (ExpiringObject)this.m_aCache.getFromCache(string)) != null) {
            if (expiringObject.isExpiredNow()) {
                LOGGER.info("The cached entry for CRL URL '" + string + "' is expired and needs to be re-fetched.");
                this.m_aCache.removeFromCache(string);
                expiringObject = (ExpiringObject)this.m_aCache.getFromCache(string);
            }
            if (expiringObject != null) {
                return (CRL)expiringObject.getObject();
            }
        }
        return null;
    }

    public void setCRLOfURL(@Nonnull @Nonempty String string, @Nonnull CRL cRL) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CRLURL");
        ValueEnforcer.notNull((Object)cRL, (String)"CRL");
        this.m_aCache.insertManually(string, (ExpiringObject<CRL>)ExpiringObject.ofDuration((Object)cRL, (Duration)this.m_aCachingDuration));
    }

    @Nonnull
    public EChange clearCache() {
        return this.m_aCache.clearCache();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Cache", (Object)this.m_aCache).append("Downloader", (Object)this.m_aDownloader).append("CachingDuration", (Object)this.m_aCachingDuration).getToString();
    }

    @Nonnull
    public static CRLCache createDefault() {
        return new CRLCache(new CRLDownloader(), DEFAULT_CACHING_DURATION);
    }

    @ThreadSafe
    private static class CRLInternalCache
    extends Cache<String, ExpiringObject<CRL>> {
        public CRLInternalCache(@Nonnull Function<String, ExpiringObject<CRL>> function, int n, @Nonnull @Nonempty String string, boolean bl) {
            super(function, n, string, bl);
        }

        private void insertManually(String string, ExpiringObject<CRL> expiringObject) {
            super.putInCache((Object)string, expiringObject);
        }
    }
}

