/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.security.keystore.IKeyStoreDescriptor;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreDescriptorBuilder;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKeyStore;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.Provider;

public class KeyStoreDescriptor
implements IKeyStoreDescriptor {
    final IKeyStoreType m_aType;
    final String m_sPath;
    final char[] m_aPassword;
    final Provider m_aProvider;
    private LoadedKeyStore m_aLKS;

    public KeyStoreDescriptor(@Nonnull IKeyStoreType iKeyStoreType, @Nonnull @Nonempty String string, @Nonnull char[] cArray, @Nullable Provider provider) {
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"Type");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.notNull((Object)cArray, (String)"Password");
        this.m_aType = iKeyStoreType;
        this.m_sPath = string;
        this.m_aPassword = cArray;
        this.m_aProvider = provider;
    }

    @Override
    @Nonnull
    public final IKeyStoreType getKeyStoreType() {
        return this.m_aType;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getKeyStorePath() {
        return this.m_sPath;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final char[] getKeyStorePassword() {
        return this.m_aPassword;
    }

    @Override
    @Nullable
    public final Provider getProvider() {
        return this.m_aProvider;
    }

    @Override
    @Nonnull
    public LoadedKeyStore loadKeyStore() {
        LoadedKeyStore loadedKeyStore = this.m_aLKS;
        if (loadedKeyStore == null) {
            loadedKeyStore = this.m_aLKS = KeyStoreHelper.loadKeyStore(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider);
        }
        return loadedKeyStore;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Type", (Object)this.m_aType).append("Path", (Object)this.m_sPath).appendPassword("Password").appendIfNotNull("Provider", (Object)this.m_aProvider).getToString();
    }

    @Nonnull
    public static KeyStoreDescriptorBuilder builder() {
        return new KeyStoreDescriptorBuilder();
    }

    @Nonnull
    public static KeyStoreDescriptorBuilder builder(@Nonnull KeyStoreDescriptor keyStoreDescriptor) {
        return new KeyStoreDescriptorBuilder(keyStoreDescriptor);
    }
}

