/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.ITrustStoreDescriptor;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKeyStore;
import java.security.Provider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TrustStoreDescriptor
implements ITrustStoreDescriptor {
    private final IKeyStoreType m_aType;
    private final String m_sPath;
    private final char[] m_aPassword;
    private final Provider m_aProvider;
    private LoadedKeyStore m_aLTS;

    public TrustStoreDescriptor(@Nonnull IKeyStoreType iKeyStoreType, @Nonnull @Nonempty String string, @Nonnull char[] cArray, @Nullable Provider provider) {
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"Type");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Path");
        ValueEnforcer.notNull((Object)cArray, (String)"Password");
        this.m_aType = iKeyStoreType;
        this.m_sPath = string;
        this.m_aPassword = cArray;
        this.m_aProvider = provider;
    }

    @Override
    @Nonnull
    public final IKeyStoreType getTrustStoreType() {
        return this.m_aType;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getTrustStorePath() {
        return this.m_sPath;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final char[] getTrustStorePassword() {
        return this.m_aPassword;
    }

    @Override
    @Nullable
    public final Provider getProvider() {
        return this.m_aProvider;
    }

    @Override
    @Nonnull
    public LoadedKeyStore loadTrustStore() {
        LoadedKeyStore loadedKeyStore = this.m_aLTS;
        if (loadedKeyStore == null) {
            loadedKeyStore = this.m_aLTS = KeyStoreHelper.loadKeyStore(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider);
        }
        return loadedKeyStore;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Type", (Object)this.m_aType).append("Path", (Object)this.m_sPath).appendPassword("Password").appendIfNotNull("Provider", (Object)this.m_aProvider).getToString();
    }

    @Nonnull
    public static TrustStoreDescriptorBuilder builder() {
        return new TrustStoreDescriptorBuilder();
    }

    @Nonnull
    public static TrustStoreDescriptorBuilder builder(@Nonnull TrustStoreDescriptor trustStoreDescriptor) {
        return new TrustStoreDescriptorBuilder(trustStoreDescriptor);
    }

    public static class TrustStoreDescriptorBuilder
    implements IBuilder<TrustStoreDescriptor> {
        private IKeyStoreType m_aType;
        private String m_sPath;
        private char[] m_aPassword;
        private Provider m_aProvider;

        public TrustStoreDescriptorBuilder() {
        }

        public TrustStoreDescriptorBuilder(@Nonnull TrustStoreDescriptor trustStoreDescriptor) {
            this.type(trustStoreDescriptor.m_aType).path(trustStoreDescriptor.m_sPath).password(trustStoreDescriptor.m_aPassword).provider(trustStoreDescriptor.m_aProvider);
        }

        @Nonnull
        public final TrustStoreDescriptorBuilder type(@Nullable IKeyStoreType iKeyStoreType) {
            this.m_aType = iKeyStoreType;
            return this;
        }

        @Nonnull
        public final TrustStoreDescriptorBuilder path(@Nullable String string) {
            this.m_sPath = string;
            return this;
        }

        @Nonnull
        public final TrustStoreDescriptorBuilder password(@Nullable String string) {
            return this.password(string == null ? null : string.toCharArray());
        }

        @Nonnull
        public final TrustStoreDescriptorBuilder password(@Nullable char[] cArray) {
            this.m_aPassword = cArray;
            return this;
        }

        @Nonnull
        public final TrustStoreDescriptorBuilder provider(@Nullable Provider provider) {
            this.m_aProvider = provider;
            return this;
        }

        @Nonnull
        public TrustStoreDescriptor build() throws IllegalStateException {
            if (this.m_aType == null) {
                throw new IllegalStateException("Type is missing");
            }
            if (StringHelper.hasNoText((String)this.m_sPath)) {
                throw new IllegalStateException("Path is empty");
            }
            if (this.m_aPassword == null) {
                throw new IllegalStateException("Password is missing");
            }
            return new TrustStoreDescriptor(this.m_aType, this.m_sPath, this.m_aPassword, this.m_aProvider);
        }
    }
}

