/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.salt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.password.salt.IPasswordSalt;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Nonnegative
@Immutable
public final class PasswordSalt
implements IPasswordSalt {
    public static final int DEFAULT_SALT_BYTES = 32;
    private final byte[] m_aSaltBytes;
    private final String m_sSaltString;

    @Deprecated
    public PasswordSalt() {
        this(32);
    }

    @Deprecated
    public PasswordSalt(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"SaltBytes");
        this.m_aSaltBytes = new byte[n];
        ThreadLocalRandom.current().nextBytes(this.m_aSaltBytes);
        this.m_sSaltString = StringHelper.getHexEncoded((byte[])this.m_aSaltBytes);
    }

    public PasswordSalt(@Nonnull @Nonempty byte[] byArray) {
        ValueEnforcer.notEmpty((byte[])byArray, (String)"Bytes");
        this.m_aSaltBytes = byArray;
        this.m_sSaltString = StringHelper.getHexEncoded((byte[])byArray);
    }

    @Override
    @Nonnegative
    public int getSaltByteCount() {
        return this.m_aSaltBytes.length;
    }

    @Override
    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public byte[] getSaltBytes() {
        return ArrayHelper.getCopy((byte[])this.m_aSaltBytes);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getSaltString() {
        return this.m_sSaltString;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordSalt passwordSalt = (PasswordSalt)object;
        return Arrays.equals(this.m_aSaltBytes, passwordSalt.m_aSaltBytes);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aSaltBytes).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("bytes#", this.m_aSaltBytes.length).getToString();
    }

    @Nonnull
    public static PasswordSalt createRandom() {
        return PasswordSalt.createRandom(32);
    }

    @Nonnull
    public static PasswordSalt createRandom(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"SaltBytes");
        byte[] byArray = new byte[n];
        ThreadLocalRandom.current().nextBytes(byArray);
        return new PasswordSalt(byArray);
    }

    @Nullable
    public static PasswordSalt createFromStringMaybe(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        byte[] byArray = StringHelper.getHexDecoded((String)string);
        return new PasswordSalt(byArray);
    }
}

