/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope.spi;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.mock.exception.IMockException;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.scope.IGlobalScope;
import com.helger.scope.IRequestScope;
import com.helger.scope.ISessionScope;
import com.helger.scope.spi.IGlobalScopeSPI;
import com.helger.scope.spi.IRequestScopeSPI;
import com.helger.scope.spi.ISessionScopeSPI;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ScopeSPIManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScopeSPIManager.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    @CodingStyleguideUnaware
    private List<IGlobalScopeSPI> m_aGlobalSPIs;
    @GuardedBy(value="m_aRWLock")
    @CodingStyleguideUnaware
    private List<ISessionScopeSPI> m_aSessionSPIs;
    @GuardedBy(value="m_aRWLock")
    @CodingStyleguideUnaware
    private List<IRequestScopeSPI> m_aRequestSPIs;

    private ScopeSPIManager() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    public static @NonNull ScopeSPIManager getInstance() {
        ScopeSPIManager scopeSPIManager = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return scopeSPIManager;
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aGlobalSPIs = ServiceLoaderHelper.getAllSPIImplementations(IGlobalScopeSPI.class);
            this.m_aSessionSPIs = ServiceLoaderHelper.getAllSPIImplementations(ISessionScopeSPI.class);
            this.m_aRequestSPIs = ServiceLoaderHelper.getAllSPIImplementations(IRequestScopeSPI.class);
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reinitialized " + ScopeSPIManager.class.getName());
        }
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<IGlobalScopeSPI> getAllGlobalScopeSPIs() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> new CommonsArrayList(this.m_aGlobalSPIs));
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<ISessionScopeSPI> getAllSessionScopeSPIs() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> new CommonsArrayList(this.m_aSessionSPIs));
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<IRequestScopeSPI> getAllRequestScopeSPIs() {
        this.m_aRWLock.readLock().lock();
        try {
            CommonsArrayList commonsArrayList = new CommonsArrayList(this.m_aRequestSPIs);
            return commonsArrayList;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    private static @Nullable Exception _propagate(@NonNull Exception exception) {
        return exception instanceof IMockException ? null : exception;
    }

    public void onGlobalScopeBegin(@NonNull IGlobalScope iGlobalScope) {
        for (IGlobalScopeSPI iGlobalScopeSPI : this.getAllGlobalScopeSPIs()) {
            try {
                iGlobalScopeSPI.onGlobalScopeBegin(iGlobalScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onGlobalScopeBegin on " + String.valueOf(iGlobalScopeSPI) + " with scope " + String.valueOf(iGlobalScope), (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    public void onGlobalScopeEnd(@NonNull IGlobalScope iGlobalScope) {
        for (IGlobalScopeSPI iGlobalScopeSPI : this.getAllGlobalScopeSPIs()) {
            try {
                iGlobalScopeSPI.onGlobalScopeEnd(iGlobalScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onGlobalScopeEnd on " + String.valueOf(iGlobalScopeSPI) + " with scope " + String.valueOf(iGlobalScope), (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    public void onSessionScopeBegin(@NonNull ISessionScope iSessionScope) {
        for (ISessionScopeSPI iSessionScopeSPI : this.getAllSessionScopeSPIs()) {
            try {
                iSessionScopeSPI.onSessionScopeBegin(iSessionScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onSessionScopeBegin on " + String.valueOf(iSessionScopeSPI) + " with scope " + String.valueOf(iSessionScope), (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    public void onSessionScopeEnd(@NonNull ISessionScope iSessionScope) {
        for (ISessionScopeSPI iSessionScopeSPI : this.getAllSessionScopeSPIs()) {
            try {
                iSessionScopeSPI.onSessionScopeEnd(iSessionScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onSessionScopeEnd on " + String.valueOf(iSessionScopeSPI) + " with scope " + String.valueOf(iSessionScope), (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    public void onRequestScopeBegin(@NonNull IRequestScope iRequestScope) {
        for (IRequestScopeSPI iRequestScopeSPI : this.getAllRequestScopeSPIs()) {
            try {
                iRequestScopeSPI.onRequestScopeBegin(iRequestScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onRequestScopeBegin on " + String.valueOf(iRequestScopeSPI) + " with scope " + String.valueOf(iRequestScope), (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    public void onRequestScopeEnd(@NonNull IRequestScope iRequestScope) {
        for (IRequestScopeSPI iRequestScopeSPI : this.getAllRequestScopeSPIs()) {
            try {
                iRequestScopeSPI.onRequestScopeEnd(iRequestScope);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke SPI method onRequestScopeEnd on " + String.valueOf(iRequestScopeSPI) + " with scope " + String.valueOf(iRequestScope), (Throwable)ScopeSPIManager._propagate(exception));
            }
        }
    }

    private static final class SingletonHolder {
        private static final ScopeSPIManager INSTANCE = new ScopeSPIManager();

        private SingletonHolder() {
        }
    }
}

