/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.scope.AbstractScope;
import com.helger.scope.IGlobalScope;
import com.helger.scope.ScopeHelper;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GlobalScope
extends AbstractScope
implements IGlobalScope {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalScope.class);

    public GlobalScope(@Nonempty @NonNull String string) {
        super(string);
        if (ScopeHelper.isDebugGlobalScopeLifeCycle()) {
            LOGGER.info("Created global scope '" + string + "'", (Throwable)ScopeHelper.getDebugException());
        }
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.isDebugGlobalScopeLifeCycle()) {
            LOGGER.info("Destroying global scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), (Throwable)ScopeHelper.getDebugException());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.isDebugGlobalScopeLifeCycle()) {
            LOGGER.info("Destroyed global scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName((Object)this), (Throwable)ScopeHelper.getDebugException());
        }
    }
}

