/*
 * Decompiled with CFR 0.152.
 */
package com.helger.scope;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.scope.IScope;
import com.helger.scope.IScopeDestructionAware;
import com.helger.typeconvert.collection.AttributeContainerAnyConcurrent;
import com.helger.typeconvert.collection.IAttributeContainerAny;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractScope
implements IScope {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractScope.class);
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final String m_sScopeID;
    private boolean m_bInPreDestruction = false;
    private boolean m_bInDestruction = false;
    private boolean m_bDestroyed = false;
    private final AttributeContainerAnyConcurrent<String> m_aAttrs = new AttributeContainerAnyConcurrent();

    protected AbstractScope(@Nonnull @Nonempty String string) {
        this.m_sScopeID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ScopeID");
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sScopeID;
    }

    @Override
    public final boolean isValid() {
        return this.m_aRWLock.readLockedBoolean(() -> !this.m_bInPreDestruction && !this.m_bInDestruction && !this.m_bDestroyed);
    }

    public final boolean isInPreDestruction() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bInPreDestruction);
    }

    @Override
    public final boolean isInDestruction() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bInDestruction);
    }

    @Override
    public final boolean isDestroyed() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bDestroyed);
    }

    @OverrideOnDemand
    protected void preDestroy() {
    }

    @OverrideOnDemand
    protected void postDestroy() {
    }

    @Override
    public final void destroyScope() {
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_bInPreDestruction) {
                throw new IllegalStateException("Scope " + this.getID() + " is already in pre destruction!");
            }
            this.m_bInPreDestruction = true;
        });
        this.preDestroy();
        ICommonsList iCommonsList = this.m_aAttrs.copyOfValuesMapped(IScopeDestructionAware.class::isInstance, IScopeDestructionAware.class::cast);
        for (IScopeDestructionAware iScopeDestructionAware : iCommonsList) {
            try {
                iScopeDestructionAware.onBeforeScopeDestruction(this);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to call onBeforeScopeDestruction in scope " + this.getID() + " for " + String.valueOf(iScopeDestructionAware), (Throwable)exception);
            }
        }
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_bDestroyed) {
                throw new IllegalStateException("Scope " + this.getID() + " is already destroyed!");
            }
            if (this.m_bInDestruction) {
                throw new IllegalStateException("Scope " + this.getID() + " is already in destruction!");
            }
            this.m_bInDestruction = true;
            this.m_bInPreDestruction = false;
        });
        for (IScopeDestructionAware iScopeDestructionAware : iCommonsList) {
            try {
                iScopeDestructionAware.onScopeDestruction(this);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to call onScopeDestruction in scope " + this.getID() + " for " + String.valueOf(iScopeDestructionAware), (Throwable)exception);
            }
        }
        this.m_aRWLock.writeLocked(() -> {
            this.m_aAttrs.clear();
            this.m_bDestroyed = true;
            this.m_bInDestruction = false;
        });
        this.postDestroy();
    }

    @Override
    @Nullable
    public final <T> T runAtomic(@Nonnull Function<? super IScope, ? extends T> function) {
        ValueEnforcer.notNull(function, (String)"Function");
        return (T)this.m_aRWLock.writeLockedGet(() -> function.apply(this));
    }

    @Override
    public final void runAtomic(@Nonnull Consumer<? super IScope> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        this.m_aRWLock.writeLocked(() -> consumer.accept(this));
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final IAttributeContainerAny<String> attrs() {
        return this.m_aAttrs;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractScope abstractScope = (AbstractScope)object;
        return this.m_sScopeID.equals(abstractScope.m_sScopeID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sScopeID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ScopeID", (Object)this.m_sScopeID).append("InPreDestruction", this.m_bInPreDestruction).append("InDestruction", this.m_bInDestruction).append("Destroyed", this.m_bDestroyed).append("Attrs", this.m_aAttrs).getToString();
    }
}

