/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mime;

import com.helger.annotation.Nonempty;
import com.helger.base.codec.impl.QuotedPrintableCodec;
import com.helger.base.codec.impl.RFC3986Codec;
import com.helger.mime.parse.MimeTypeParser;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.jspecify.annotations.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EMimeQuoting {
    QUOTED_STRING{

        @Override
        public @NonNull @Nonempty String getQuotedString(@NonNull @Nonempty String string) {
            char[] cArray;
            StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
            stringBuilder.append('\"');
            for (char c : cArray = string.toCharArray()) {
                if (c == '\"' || c == '\\') {
                    stringBuilder.append('\\').append(c);
                    continue;
                }
                stringBuilder.append(c);
            }
            return stringBuilder.append('\"').toString();
        }

        @Override
        public @NonNull @Nonempty String getUnquotedString(@NonNull @Nonempty String string) {
            throw new UnsupportedOperationException("This is handled directly inside the MimeTypeParser!");
        }
    }
    ,
    QUOTED_PRINTABLE{

        @Override
        public @NonNull @Nonempty String getQuotedString(@NonNull @Nonempty String string) {
            return new QuotedPrintableCodec(PRINTABLE_QUOTED_PRINTABLE).getEncodedAsString(string, StandardCharsets.UTF_8);
        }

        @Override
        public @NonNull @Nonempty String getUnquotedString(@NonNull @Nonempty String string) {
            return new QuotedPrintableCodec().getDecodedAsString(string, StandardCharsets.UTF_8);
        }
    }
    ,
    URL_ESCAPE{

        @Override
        public @NonNull @Nonempty String getQuotedString(@NonNull @Nonempty String string) {
            return new RFC3986Codec(PRINTABLE_URL).getEncodedAsString(string, StandardCharsets.UTF_8);
        }

        @Override
        public @NonNull @Nonempty String getUnquotedString(@NonNull @Nonempty String string) {
            return new RFC3986Codec(PRINTABLE_URL).getDecodedAsString(string, StandardCharsets.UTF_8);
        }
    };

    public static final char QUOTED_STRING_SEPARATOR_CHAR = '\"';
    public static final char QUOTED_STRING_MASK_CHAR = '\\';
    private static final BitSet PRINTABLE_QUOTED_PRINTABLE;
    private static final BitSet PRINTABLE_URL;

    public abstract @NonNull @Nonempty String getQuotedString(@NonNull @Nonempty String var1);

    public abstract @NonNull @Nonempty String getUnquotedString(@NonNull @Nonempty String var1);

    public boolean isQuotedString() {
        return this == QUOTED_STRING;
    }

    static {
        PRINTABLE_QUOTED_PRINTABLE = QuotedPrintableCodec.getDefaultPrintableChars();
        PRINTABLE_URL = RFC3986Codec.getDefaultPrintableChars();
        PRINTABLE_QUOTED_PRINTABLE.set(9, false);
        PRINTABLE_QUOTED_PRINTABLE.set(32, false);
        PRINTABLE_URL.set(32, false);
        for (char c : MimeTypeParser.getAllTSpecialChars()) {
            PRINTABLE_QUOTED_PRINTABLE.set((int)c, false);
            PRINTABLE_URL.set((int)c, false);
        }
    }
}

