/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mime.parse;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.codec.DecodeException;
import com.helger.base.codec.impl.RFC2616Codec;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.mime.CMimeType;
import com.helger.mime.EMimeContentType;
import com.helger.mime.EMimeQuoting;
import com.helger.mime.MimeType;
import com.helger.mime.parse.MimeTypeParserException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MimeTypeParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeTypeParser.class);
    private static final char[] TSPECIAL = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '='};
    private static final MimeTypeParser INSTANCE = new MimeTypeParser();

    private MimeTypeParser() {
    }

    @ReturnsMutableCopy
    public static @NonNull char[] getAllTSpecialChars() {
        return ArrayHelper.getCopy((char[])TSPECIAL);
    }

    public static boolean isTSpecialChar(char c) {
        return ArrayHelper.contains((char[])TSPECIAL, (char)c);
    }

    public static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && !MimeTypeParser.isTSpecialChar(c);
    }

    public static boolean isToken(@Nullable String string) {
        char[] cArray;
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        for (char c : cArray = string.toCharArray()) {
            if (MimeTypeParser.isTokenChar(c)) continue;
            return false;
        }
        return true;
    }

    private static void _parseAndAddParameters(@NonNull MimeType mimeType, @Nonempty @NonNull String string, @NonNull EMimeQuoting eMimeQuoting) throws MimeTypeParserException {
        block26: {
            String[] stringArray;
            if (eMimeQuoting.isQuotedString()) {
                char[] cArray = string.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                block6: while (true) {
                    int n3 = n2;
                    while (n2 < n && MimeTypeParser.isTokenChar(cArray[n2])) {
                        ++n2;
                    }
                    String string2 = string.substring(n3, n2);
                    if (string2.length() == 0) break block26;
                    while (n2 < n && cArray[n2] != '=') {
                        ++n2;
                    }
                    if (n2 == n) {
                        throw new MimeTypeParserException("Missing parameter name/value separator");
                    }
                    ++n2;
                    while (n2 < n && cArray[n2] != '\"' && !MimeTypeParser.isTokenChar(cArray[n2])) {
                        ++n2;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    if (n2 < n) {
                        if (cArray[n2] == '\"') {
                            char c;
                            ++n2;
                            while (n2 < n && (c = cArray[n2]) != '\"') {
                                if (c == '\\') {
                                    if (n2 == n - 1) {
                                        throw new MimeTypeParserException("Illegal masking found at end of: " + string);
                                    }
                                    stringBuilder.append(cArray[++n2]);
                                } else {
                                    stringBuilder.append(c);
                                }
                                ++n2;
                            }
                            if (n2 == n) {
                                throw new MimeTypeParserException("Missing closing separator in quoted value");
                            }
                            ++n2;
                        } else {
                            while (n2 < n && MimeTypeParser.isTokenChar(cArray[n2])) {
                                stringBuilder.append(cArray[n2]);
                                ++n2;
                            }
                        }
                    }
                    String string3 = stringBuilder.toString();
                    try {
                        mimeType.addParameter(string2, string3);
                    }
                    catch (Exception exception) {
                        throw new MimeTypeParserException("Failed to add parameter '" + string2 + "' with value '" + string3 + "'", exception);
                    }
                    while (n2 < n && cArray[n2] != ';') {
                        ++n2;
                    }
                    if (n2 != n) {
                        ++n2;
                        while (true) {
                            if (n2 >= n || MimeTypeParser.isTokenChar(cArray[n2])) continue block6;
                            ++n2;
                        }
                    }
                    break block26;
                    break;
                }
            }
            for (String string4 : stringArray = StringHelper.getExplodedArray((char)';', (String)string)) {
                if (string4.length() <= 0) continue;
                String[] stringArray2 = StringHelper.getExplodedArray((char)'=', (String)string4, (int)2);
                if (stringArray2.length != 2) {
                    throw new MimeTypeParserException("MimeType Parameter without name/value separator found: '" + string4 + "'");
                }
                String string5 = stringArray2[0].trim();
                String string6 = stringArray2[1].trim();
                try {
                    string6 = eMimeQuoting.getUnquotedString(string6);
                }
                catch (DecodeException decodeException) {
                    throw new MimeTypeParserException("Failed to unquote the string '" + string6 + "'", decodeException);
                }
                try {
                    mimeType.addParameter(string5, string6);
                }
                catch (Exception exception) {
                    throw new MimeTypeParserException("Failed to add parameter '" + string5 + "' with value '" + string6 + "'", exception);
                }
            }
        }
    }

    public static @Nullable MimeType parseMimeType(@Nullable String string) throws MimeTypeParserException {
        return MimeTypeParser.parseMimeType(string, CMimeType.DEFAULT_QUOTING);
    }

    public static @Nullable MimeType parseMimeType(@Nullable String string, @NonNull EMimeQuoting eMimeQuoting) throws MimeTypeParserException {
        String string2;
        String string3;
        ValueEnforcer.notNull((Object)((Object)eMimeQuoting), (String)"QuotingAlgorithm");
        String string4 = StringHelper.trim((String)string);
        if (StringHelper.isEmpty((String)string4)) {
            return null;
        }
        if (string4.equals("*")) {
            return new MimeType(EMimeContentType._STAR, "*");
        }
        int n = string4.indexOf(47);
        if (n < 0) {
            throw new MimeTypeParserException("MimeType '" + string4 + "' is missing the main '/' separator char");
        }
        String string5 = string4.substring(0, n).trim();
        EMimeContentType eMimeContentType = EMimeContentType.getFromIDOrNull(string5);
        if (eMimeContentType == null) {
            throw new MimeTypeParserException("MimeType '" + string4 + "' uses an unknown content type '" + string5 + "'");
        }
        String string6 = string4.substring(n + 1);
        int n2 = string6.indexOf(59);
        if (n2 >= 0) {
            string3 = string6.substring(0, n2).trim();
            string2 = string6.substring(n2 + 1).trim();
        } else {
            string3 = string6.trim();
            string2 = null;
        }
        if (StringHelper.isEmpty((String)string3)) {
            throw new MimeTypeParserException("MimeType '" + string4 + "' uses an empty content sub type '" + string4 + "'");
        }
        MimeType mimeType = new MimeType(eMimeContentType, string3);
        if (StringHelper.isNotEmpty((String)string2)) {
            MimeTypeParser._parseAndAddParameters(mimeType, string2, eMimeQuoting);
        }
        return mimeType;
    }

    public static @Nullable MimeType safeParseMimeType(@Nullable String string) {
        return MimeTypeParser.safeParseMimeType(string, CMimeType.DEFAULT_QUOTING);
    }

    public static @Nullable MimeType safeParseMimeType(@Nullable String string, @NonNull EMimeQuoting eMimeQuoting) {
        String string2 = string;
        if (RFC2616Codec.isMaybeEncoded((String)string2)) {
            try {
                string2 = new RFC2616Codec().getDecodedAsString(string2);
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
        try {
            return MimeTypeParser.parseMimeType(string2, eMimeQuoting);
        }
        catch (MimeTypeParserException mimeTypeParserException) {
            if ("*".equals(string2)) {
                return new MimeType(EMimeContentType._STAR, "*");
            }
            LOGGER.warn("Unparsable MIME type '" + string + "'");
            return null;
        }
    }
}

