/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.valueserializer;

import com.helger.annotation.WillNotClose;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.json.valueserializer.IJsonValueSerializer;
import com.helger.typeconvert.impl.TypeConverter;
import java.io.IOException;
import java.io.Writer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class JsonValueSerializerTypeConverterToString
implements IJsonValueSerializer {
    private static final JsonValueSerializerTypeConverterToString INSTANCE = new JsonValueSerializerTypeConverterToString();

    private JsonValueSerializerTypeConverterToString() {
    }

    public static @NonNull JsonValueSerializerTypeConverterToString getInstance() {
        return INSTANCE;
    }

    @Override
    public void appendAsJsonString(@Nullable Object object, @WillNotClose @NonNull Writer writer) throws IOException {
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        String string = (String)TypeConverter.convert((Object)object, String.class);
        writer.write(string);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

