/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EChange;
import com.helger.base.trait.IGenericMapAdderTrait;
import com.helger.base.trait.ITypeConverterTo;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonCollection;
import com.helger.json.IJsonValue;
import com.helger.json.JsonValue;
import com.helger.json.TypeConverterToIJson;
import com.helger.typeconvert.trait.IGetterByKeyTrait;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface IJsonObject
extends IJsonCollection,
ICommonsIterable<Map.Entry<String, IJson>>,
IGetterByKeyTrait<String>,
IGenericMapAdderTrait<String, IJson, IJsonObject> {
    default public @NonNull ITypeConverterTo<IJson> getTypeConverterTo() {
        return TypeConverterToIJson.INSTANCE;
    }

    @Nonnegative
    public int size();

    public @Nullable IJson removeKeyAndReturnValue(@Nullable String var1);

    public @NonNull EChange removeKey(@Nullable String var1);

    public boolean containsKey(@Nullable String var1);

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<String> keySet();

    @ReturnsMutableCopy
    public @NonNull ICommonsList<IJson> values();

    public @Nullable IJson get(@Nullable String var1);

    default public @Nullable Object getValue(@Nullable String string) {
        IJsonValue iJsonValue;
        IJson iJson = this.get(string);
        if (iJson != null && (iJsonValue = iJson.getAsValue()) != null) {
            return iJsonValue.getValue();
        }
        return null;
    }

    default public @Nullable IJsonValue getAsValue(@Nullable String string) {
        IJson iJson = this.get(string);
        return iJson != null ? iJson.getAsValue() : null;
    }

    default public @Nullable IJsonArray getAsArray(@Nullable String string) {
        IJson iJson = this.get(string);
        return iJson != null ? iJson.getAsArray() : null;
    }

    default public @Nullable IJsonObject getAsObject(@Nullable String string) {
        IJson iJson = this.get(string);
        return iJson != null ? iJson.getAsObject() : null;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsMap<String, IJson> getAll();

    public void forEach(@NonNull BiConsumer<? super String, ? super IJson> var1);

    public boolean containsValue(@Nullable IJson var1);

    default public boolean containsValue(@Nullable Object object) {
        return this.containsValue(JsonValue.create(object));
    }

    default public boolean containsValue(boolean bl) {
        return this.containsValue(JsonValue.create(bl));
    }

    default public boolean containsValue(char c) {
        return this.containsValue(JsonValue.create(c));
    }

    default public boolean containsValue(double d) {
        return this.containsValue(JsonValue.create(d));
    }

    default public boolean containsValue(int n) {
        return this.containsValue(JsonValue.create(n));
    }

    default public boolean containsValue(long l) {
        return this.containsValue(JsonValue.create(l));
    }

    default public @Nullable IJson computeIfAbsent(@NonNull String string, @NonNull Function<? super String, ? extends IJson> function) {
        IJson iJson = this.get(string);
        if (iJson == null && (iJson = function.apply(string)) != null) {
            this.add(string, iJson);
        }
        return iJson;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedMap<String, IJson> getClonedValues();

    public @NonNull IJsonObject getClone();
}

