/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.serialize;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.nonblocking.NonBlockingStringReader;
import com.helger.base.io.stream.NonClosingReader;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.base.state.EValidity;
import com.helger.io.resource.FileSystemResource;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.IJsonValue;
import com.helger.json.parser.IJsonParserSettings;
import com.helger.json.parser.JsonParseException;
import com.helger.json.parser.JsonParser;
import com.helger.json.parser.JsonParserSettings;
import com.helger.json.parser.errorhandler.IJsonParseExceptionCallback;
import com.helger.json.parser.errorhandler.LoggingJsonParseExceptionCallback;
import com.helger.json.parser.handler.CollectingJsonParserHandler;
import com.helger.json.parser.handler.DoNothingJsonParserHandler;
import com.helger.json.parser.handler.IJsonParserHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JsonReader {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonReader.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IJsonParseExceptionCallback s_aDefaultParseExceptionCallback = new LoggingJsonParseExceptionCallback();
    private static final JsonReader INSTANCE = new JsonReader();

    private JsonReader() {
    }

    @Nonnull
    public static IJsonParseExceptionCallback getDefaultParseExceptionCallback() {
        return (IJsonParseExceptionCallback)RW_LOCK.readLockedGet(() -> s_aDefaultParseExceptionCallback);
    }

    public static void setDefaultParseExceptionCallback(@Nonnull IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        ValueEnforcer.notNull((Object)iJsonParseExceptionCallback, (String)"DefaultParseExceptionCallback");
        RW_LOCK.writeLocked(() -> {
            s_aDefaultParseExceptionCallback = iJsonParseExceptionCallback;
        });
    }

    @Nonnull
    public static ESuccess parseJson(@Nonnull @WillClose Reader reader, @Nonnull IJsonParserHandler iJsonParserHandler) {
        return JsonReader.parseJson(reader, iJsonParserHandler, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess parseJson(@Nonnull @WillClose Reader reader, @Nonnull IJsonParserHandler iJsonParserHandler, @Nullable IJsonParserSettings iJsonParserSettings, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)iJsonParserHandler, (String)"ParserHandler");
        try {
            JsonParser jsonParser = new JsonParser(reader, iJsonParserHandler);
            if (iJsonParserSettings != null) {
                jsonParser.jsonParserSettings().assignFrom(iJsonParserSettings);
            }
            jsonParser.parse();
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (JsonParseException jsonParseException) {
            if (iJsonParseExceptionCallback != null) {
                iJsonParseExceptionCallback.onException(jsonParseException);
            } else {
                JsonReader.getDefaultParseExceptionCallback().onException(jsonParseException);
            }
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    @Nonnull
    private static EValidity _validateJson(@Nonnull @WillClose Reader reader) {
        ESuccess eSuccess = JsonReader.parseJson(reader, new DoNothingJsonParserHandler(), null, jsonParseException -> {});
        return EValidity.valueOf((boolean)eSuccess.isSuccess());
    }

    @Nullable
    public static IJson readJson(@Nonnull @WillClose Reader reader, @Nullable IJsonParserSettings iJsonParserSettings, @Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
        CollectingJsonParserHandler collectingJsonParserHandler = new CollectingJsonParserHandler();
        if (JsonReader.parseJson(reader, collectingJsonParserHandler, iJsonParserSettings, iJsonParseExceptionCallback).isFailure()) {
            return null;
        }
        return collectingJsonParserHandler.getJson();
    }

    @Nullable
    public static IJson readFromString(@Nonnull String string) {
        return JsonReader.builder().source(string).read();
    }

    @Nonnull
    public static JsonBuilder builder() {
        return new JsonBuilder();
    }

    @Nonnull
    public static JsonBuilder builderMultiObject() {
        return JsonReader.builder().dontCloseSource(true).useBufferedReader(false).checkForEOI(false);
    }

    public static class JsonBuilder
    implements AutoCloseable {
        private boolean m_bDontCloseSource = false;
        private boolean m_bUseBufferedReader = true;
        private Reader m_aReader;
        private final JsonParserSettings m_aParserSettings = new JsonParserSettings();
        private IJsonParseExceptionCallback m_aCustomExceptionCallback;

        @Override
        public void close() {
            StreamHelper.close((AutoCloseable)this.m_aReader);
        }

        @Nonnull
        public JsonBuilder dontCloseSource(boolean bl) {
            this.m_bDontCloseSource = bl;
            return this;
        }

        @Nonnull
        public JsonBuilder useBufferedReader(boolean bl) {
            this.m_bUseBufferedReader = bl;
            return this;
        }

        @Nonnull
        public JsonBuilder source(@Nonnull String string) {
            ValueEnforcer.notNull((Object)string, (String)"Json");
            return this.source((Reader)new NonBlockingStringReader(string));
        }

        @Nonnull
        public JsonBuilder source(@Nonnull File file) {
            return this.source(file, DEFAULT_CHARSET);
        }

        @Nonnull
        public JsonBuilder source(@Nonnull File file, @Nonnull Charset charset) {
            ValueEnforcer.notNull((Object)file, (String)"File");
            ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
            return this.source((IHasInputStream)new FileSystemResource(file), charset);
        }

        @Nonnull
        public JsonBuilder source(@Nonnull Path path) {
            return this.source(path, DEFAULT_CHARSET);
        }

        @Nonnull
        public JsonBuilder source(@Nonnull Path path, @Nonnull Charset charset) {
            ValueEnforcer.notNull((Object)path, (String)"Path");
            ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
            return this.source((IHasInputStream)new FileSystemResource(path), charset);
        }

        @Nonnull
        public JsonBuilder source(@Nonnull byte[] byArray) {
            return this.source(byArray, DEFAULT_CHARSET);
        }

        @Nonnull
        public JsonBuilder source(@Nonnull byte[] byArray, @Nonnull Charset charset) {
            ValueEnforcer.notNull((Object)byArray, (String)"Bytes");
            ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
            return this.source((InputStream)new NonBlockingByteArrayInputStream(byArray), charset);
        }

        @Nonnull
        public JsonBuilder source(@Nonnull IHasInputStream iHasInputStream) {
            return this.source(iHasInputStream, DEFAULT_CHARSET);
        }

        @Nonnull
        public JsonBuilder source(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset) {
            ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
            ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
            InputStream inputStream = iHasInputStream.getInputStream();
            if (inputStream != null) {
                this.source(inputStream, charset);
            }
            return this;
        }

        @Nonnull
        public JsonBuilder source(@Nonnull @WillClose InputStream inputStream) {
            return this.source(inputStream, DEFAULT_CHARSET);
        }

        @Nonnull
        public JsonBuilder source(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset) {
            ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
            ValueEnforcer.notNull((Object)charset, (String)"FallbackCharset");
            return this.source(CharsetHelper.getReaderByBOM((InputStream)inputStream, (Charset)charset));
        }

        @Nonnull
        public JsonBuilder source(@Nonnull @WillClose Reader reader) {
            ValueEnforcer.notNull((Object)reader, (String)"Reader");
            if (this.m_aReader != null) {
                LOGGER.warn("Another source is already present - this may cause a resource leak, because the old source is not closed automatically");
            }
            this.m_aReader = reader;
            return this;
        }

        @Nonnull
        public JsonBuilder trackPosition(boolean bl) {
            this.m_aParserSettings.setTrackPosition(bl);
            return this;
        }

        @Nonnull
        public JsonBuilder tabSize(@Nonnegative int n) {
            this.m_aParserSettings.setTabSize(n);
            return this;
        }

        @Nonnull
        public JsonBuilder alwaysUseBigNumber(boolean bl) {
            this.m_aParserSettings.setAlwaysUseBigNumber(bl);
            return this;
        }

        @Nonnull
        public JsonBuilder requireStringQuotes(boolean bl) {
            this.m_aParserSettings.setRequireStringQuotes(bl);
            return this;
        }

        @Nonnull
        public JsonBuilder allowSpecialCharsInStrings(boolean bl) {
            this.m_aParserSettings.setAllowSpecialCharsInStrings(bl);
            return this;
        }

        @Nonnull
        public JsonBuilder checkForEOI(boolean bl) {
            this.m_aParserSettings.setCheckForEOI(bl);
            return this;
        }

        @Nonnull
        public JsonBuilder maxNestingDepth(@Nonnegative int n) {
            this.m_aParserSettings.setMaxNestingDepth(n);
            return this;
        }

        @Nonnull
        public JsonBuilder customExceptionCallback(@Nullable IJsonParseExceptionCallback iJsonParseExceptionCallback) {
            this.m_aCustomExceptionCallback = iJsonParseExceptionCallback;
            return this;
        }

        public boolean hasSource() {
            return this.m_aReader != null;
        }

        @Nonnull
        private Reader _getEffectiveReader() {
            Reader reader = this.m_aReader;
            if (this.m_bUseBufferedReader) {
                reader = StreamHelper.getBuffered((Reader)reader);
            }
            if (this.m_bDontCloseSource) {
                reader = new NonClosingReader(reader);
            }
            return reader;
        }

        public boolean isValidJson() {
            if (this.m_aReader == null) {
                throw new IllegalStateException("No source is set.");
            }
            return JsonReader.parseJson(this._getEffectiveReader(), new DoNothingJsonParserHandler(), this.m_aParserSettings, this.m_aCustomExceptionCallback).isSuccess();
        }

        @Nullable
        public IJson read() {
            if (this.m_aReader == null) {
                throw new IllegalStateException("No source is set.");
            }
            return JsonReader.readJson(this._getEffectiveReader(), this.m_aParserSettings, this.m_aCustomExceptionCallback);
        }

        @Nullable
        public IJsonArray readAsArray() {
            IJson iJson = this.read();
            return iJson == null ? null : iJson.getAsArray();
        }

        @Nullable
        public IJsonObject readAsObject() {
            IJson iJson = this.read();
            return iJson == null ? null : iJson.getAsObject();
        }

        @Nullable
        public IJsonValue readAsValue() {
            IJson iJson = this.read();
            return iJson == null ? null : iJson.getAsValue();
        }
    }
}

