/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.convert;

import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.exception.InitializationException;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringHex;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Writer;

@Immutable
public final class JsonEscapeHelper {
    public static final char MASK_CHAR = '\\';
    public static final String MASK_STRING = Character.toString('\\');
    private static final char[] CHARS_TO_MASK = new char[]{'\u0000', '\"', '\\', '\b', '\t', '\n', '\r', '\f'};
    private static final String[] REPLACEMENT_STRINGS = new String[]{"\\u0000", "\\\"", "\\\\", "\\b", "\\t", "\\n", "\\r", "\\f"};
    private static final JsonEscapeHelper INSTANCE;

    private JsonEscapeHelper() {
    }

    public static void jsonEscapeToStringBuilder(@Nonnull char[] cArray, @Nonnull StringBuilder stringBuilder) {
        ValueEnforcer.notNull((Object)cArray, (String)"Input");
        ValueEnforcer.notNull((Object)stringBuilder, (String)"StringBuilder");
        for (char c : cArray) {
            int n = ArrayHelper.getFirstIndex((char[])CHARS_TO_MASK, (char)c);
            if (n >= 0) {
                stringBuilder.append(REPLACEMENT_STRINGS[n]);
                continue;
            }
            stringBuilder.append(c);
        }
    }

    @Nullable
    public static String jsonEscape(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return string;
        }
        return JsonEscapeHelper.jsonEscape(string.toCharArray());
    }

    @Nullable
    public static String jsonEscape(@Nullable char[] cArray) {
        if (cArray == null) {
            return null;
        }
        if (!StringHelper.containsAny((char[])cArray, (char[])CHARS_TO_MASK)) {
            return new String(cArray);
        }
        StringBuilder stringBuilder = new StringBuilder(cArray.length * 2);
        JsonEscapeHelper.jsonEscapeToStringBuilder(cArray, stringBuilder);
        return stringBuilder.toString();
    }

    public static void jsonEscape(@Nullable String string, @Nonnull StringBuilder stringBuilder) {
        ValueEnforcer.notNull((Object)stringBuilder, (String)"StringBuilder");
        if (StringHelper.isNotEmpty((String)string)) {
            char[] cArray = string.toCharArray();
            if (!StringHelper.containsAny((char[])cArray, (char[])CHARS_TO_MASK)) {
                stringBuilder.append(string);
            } else {
                JsonEscapeHelper.jsonEscapeToStringBuilder(cArray, stringBuilder);
            }
        }
    }

    public static void jsonEscapeToWriter(@Nonnull char[] cArray, @Nonnull @WillNotClose Writer writer) throws IOException {
        ValueEnforcer.notNull((Object)cArray, (String)"Input");
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        for (char c : cArray) {
            int n = ArrayHelper.getFirstIndex((char[])CHARS_TO_MASK, (char)c);
            if (n >= 0) {
                writer.write(REPLACEMENT_STRINGS[n]);
                continue;
            }
            writer.write(c);
        }
    }

    public static void jsonEscapeToWriter(@Nullable String string, @Nonnull @WillNotClose Writer writer) throws IOException {
        ValueEnforcer.notNull((Object)writer, (String)"Writer");
        if (StringHelper.isNotEmpty((String)string)) {
            char[] cArray = string.toCharArray();
            if (!StringHelper.containsAny((char[])cArray, (char[])CHARS_TO_MASK)) {
                writer.write(cArray, 0, cArray.length);
            } else {
                JsonEscapeHelper.jsonEscapeToWriter(cArray, writer);
            }
        }
    }

    private static int _hexval(char c) {
        int n = StringHex.getHexValue((char)c);
        if (n < 0) {
            throw new IllegalArgumentException("Illegal hex char '" + c + "'");
        }
        return n;
    }

    public static void jsonUnescapeToStringBuilder(@Nonnull char[] cArray, @Nonnull StringBuilder stringBuilder) {
        ValueEnforcer.notNull((Object)cArray, (String)"Input");
        ValueEnforcer.notNull((Object)stringBuilder, (String)"StringBuilder");
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c == '\\') {
                if (i > n - 1) {
                    throw new IllegalArgumentException("JSON string ends with escape char");
                }
                char c2 = cArray[++i];
                switch (c2) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        stringBuilder.append(c2);
                        break;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        break;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder.append('\t');
                        break;
                    }
                    case 'u': {
                        if (i + 4 > n - 1) {
                            throw new IllegalArgumentException("JSON unicode escape sequence \\uXXXX is incomplete: " + new String(cArray, i - 1, 6));
                        }
                        char c3 = cArray[++i];
                        char c4 = cArray[++i];
                        char c5 = cArray[++i];
                        char c6 = cArray[++i];
                        stringBuilder.append((char)(JsonEscapeHelper._hexval(c3) << 12 | JsonEscapeHelper._hexval(c4) << 8 | JsonEscapeHelper._hexval(c5) << 4 | JsonEscapeHelper._hexval(c6)));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected JSON escape sequence: \\" + c2 + " (" + c2 + ")");
                    }
                }
                continue;
            }
            stringBuilder.append(c);
        }
    }

    @Nonnull
    public static String jsonUnescape(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Input");
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        JsonEscapeHelper.jsonUnescapeToStringBuilder(string.toCharArray(), stringBuilder);
        return stringBuilder.toString();
    }

    @Nonnull
    public static String jsonUnescape(@Nonnull char[] cArray) {
        ValueEnforcer.notNull((Object)cArray, (String)"Input");
        if (!ArrayHelper.contains((char[])cArray, (char)'\\')) {
            return new String(cArray);
        }
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        JsonEscapeHelper.jsonUnescapeToStringBuilder(cArray, stringBuilder);
        return stringBuilder.toString();
    }

    static {
        if (CHARS_TO_MASK.length != REPLACEMENT_STRINGS.length) {
            throw new InitializationException("Length are inconsistent");
        }
        INSTANCE = new JsonEscapeHelper();
    }
}

