/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.serialize.JsonReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;

@NotThreadSafe
public class JsonArray
implements IJsonArray {
    private ICommonsList<IJson> m_aValues;

    public JsonArray() {
        this(16);
    }

    public JsonArray(@Nonnegative int n) {
        this.m_aValues = new CommonsArrayList(n);
    }

    public JsonArray(@Nonnull Iterable<? extends IJson> iterable) {
        ValueEnforcer.notNull(iterable, (String)"Jsons");
        this.m_aValues = new CommonsArrayList(iterable);
    }

    public JsonArray(IJson ... iJsonArray) {
        ValueEnforcer.notNull((Object)iJsonArray, (String)"Jsons");
        this.m_aValues = new CommonsArrayList((Object[])iJsonArray);
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.m_aValues.size());
        String string = this.getAsJsonString();
        StreamHelper.writeSafeUTF((DataOutput)objectOutputStream, (String)string);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        this.m_aValues = new CommonsArrayList(n);
        String string = StreamHelper.readSafeUTF((DataInput)objectInputStream);
        JsonArray jsonArray = (JsonArray)JsonReader.readFromString(string);
        if (jsonArray == null) {
            throw new IOException("Failed to parse JSON array:\n" + string);
        }
        this.m_aValues.addAll(jsonArray.m_aValues);
    }

    @Override
    public final boolean isArray() {
        return true;
    }

    @Override
    public final boolean isObject() {
        return false;
    }

    @Override
    public final boolean isValue() {
        return false;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aValues.size();
    }

    public boolean isEmpty() {
        return this.m_aValues.isEmpty();
    }

    @Nonnull
    public Iterator<IJson> iterator() {
        return this.m_aValues.iterator();
    }

    @Nonnull
    public JsonArray add(@Nonnull IJson iJson) {
        ValueEnforcer.notNull((Object)iJson, (String)"Value");
        this.m_aValues.add((Object)iJson);
        return this;
    }

    @Nonnull
    public JsonArray addAt(@Nonnegative int n, @Nonnull IJson iJson) {
        ValueEnforcer.notNull((Object)iJson, (String)"Value");
        this.m_aValues.add(n, (Object)iJson);
        return this;
    }

    @Override
    @Nonnull
    public IJson removeAndReturnAtIndex(@Nonnegative int n) {
        return (IJson)this.m_aValues.removeAndReturnElementAtIndex(n);
    }

    @Override
    @Nonnull
    public EChange removeAtIndex(@Nonnegative int n) {
        return this.m_aValues.removeAtIndex(n);
    }

    @Override
    @Nullable
    public IJson get(@Nonnegative int n) {
        return (IJson)this.m_aValues.getAtIndex(n);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public JsonArray getSubArray(@Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGE0((int)n, (String)"StartIndex");
        ValueEnforcer.isBetweenInclusive((int)n2, (String)"EndIndex", (int)n, (int)this.m_aValues.size());
        int n3 = n2 - n;
        JsonArray jsonArray = new JsonArray(n3);
        jsonArray.addAll(this.m_aValues.subList(n, n2));
        return jsonArray;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJson> getAll() {
        return (ICommonsList)this.m_aValues.getClone();
    }

    public void forEach(@Nonnull Consumer<? super IJson> consumer) {
        this.m_aValues.forEach(consumer);
    }

    @Override
    public void forEachByIndex(@Nonnull ObjIntConsumer<? super IJson> objIntConsumer) {
        this.m_aValues.forEachByIndex(objIntConsumer);
    }

    @Override
    public boolean contains(@Nullable IJson iJson) {
        return iJson != null && this.m_aValues.contains((Object)iJson);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJson> getClonedValues() {
        return this.m_aValues.getAllMapped(ICloneable::getClone);
    }

    @Override
    @Nonnull
    public JsonArray getClone() {
        return new JsonArray((Iterable<? extends IJson>)this.getClonedValues());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JsonArray jsonArray = (JsonArray)object;
        return this.m_aValues.equals(jsonArray.m_aValues);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValues).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("values", this.m_aValues).getToString();
    }
}

