/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.json.IJsonValue;
import com.helger.json.serialize.JsonReader;
import com.helger.json.valueserializer.IJsonValueSerializer;
import com.helger.json.valueserializer.JsonValueSerializerConstant;
import com.helger.json.valueserializer.JsonValueSerializerEscaped;
import com.helger.json.valueserializer.JsonValueSerializerRegistry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public class JsonValue
implements IJsonValue {
    public static final JsonValue NULL = new JsonValue(null);
    public static final JsonValue TRUE = new JsonValue(Boolean.TRUE);
    public static final JsonValue FALSE = new JsonValue(Boolean.FALSE);
    private static final int INT_CACHE_MIN = -128;
    private static final int INT_CACHE_MAX = 127;
    private static final JsonValue[] NUMERIC = new JsonValue[256];
    private Object m_aValue;

    protected JsonValue(@Nullable Object object) {
        this.m_aValue = object;
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        this.appendAsJsonString((Writer)nonBlockingStringWriter);
        StreamHelper.writeSafeUTF((DataOutput)objectOutputStream, (String)nonBlockingStringWriter.getAsString());
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
        String string = StreamHelper.readSafeUTF((DataInput)objectInputStream);
        JsonValue jsonValue = (JsonValue)JsonReader.readFromString(string);
        this.m_aValue = jsonValue.m_aValue;
    }

    @Override
    public final boolean isArray() {
        return false;
    }

    @Override
    public final boolean isObject() {
        return false;
    }

    @Override
    public final boolean isValue() {
        return true;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.m_aValue;
    }

    @Override
    public boolean isBooleanValue() {
        return this == TRUE || this == FALSE;
    }

    @Override
    public boolean isIntValue() {
        return this.m_aValue instanceof BigInteger || this.m_aValue instanceof Integer || this.m_aValue instanceof Long;
    }

    @Override
    public boolean isDecimalValue() {
        return this.m_aValue instanceof BigDecimal || this.m_aValue instanceof Double;
    }

    @Override
    public boolean isStringValue() {
        return this.m_aValue instanceof String;
    }

    @Nonnull
    public static IJsonValueSerializer getDefaultJsonValueSerializer() {
        return JsonValueSerializerEscaped.getInstance();
    }

    @Override
    @Nonnull
    public IJsonValueSerializer getValueSerializer() {
        if (this == NULL) {
            return JsonValueSerializerConstant.NULL;
        }
        if (this == TRUE) {
            return JsonValueSerializerConstant.TRUE;
        }
        if (this == FALSE) {
            return JsonValueSerializerConstant.FALSE;
        }
        IJsonValueSerializer iJsonValueSerializer = JsonValueSerializerRegistry.getInstance().getJsonValueSerializer(this.getValueClass());
        if (iJsonValueSerializer == null) {
            iJsonValueSerializer = JsonValue.getDefaultJsonValueSerializer();
        }
        return iJsonValueSerializer;
    }

    @Override
    public void appendAsJsonString(@Nonnull @WillNotClose Writer writer) throws IOException {
        this.getValueSerializer().appendAsJsonString(this.m_aValue, writer);
    }

    @Override
    @Nonnull
    public JsonValue getClone() {
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JsonValue jsonValue = (JsonValue)object;
        return EqualsHelper.equals((Object)this.m_aValue, (Object)jsonValue.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Value", this.m_aValue).append("ValueClass", (Object)ClassHelper.getClassLocalName((Object)this.m_aValue)).getToString();
    }

    @Nonnull
    public static JsonValue create(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @Nonnull
    public static JsonValue create(char c) {
        return JsonValue.create(Character.toString(c));
    }

    @Nonnull
    public static JsonValue create(double d) {
        return JsonValue.create((Object)d);
    }

    @Nonnull
    public static JsonValue create(int n) {
        if (n >= -128 && n < 127) {
            return NUMERIC[n - -128];
        }
        return JsonValue.create((Object)n);
    }

    @Nonnull
    public static JsonValue create(long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return JsonValue.create((int)l);
        }
        return JsonValue.create((Object)l);
    }

    @Nonnull
    @SuppressFBWarnings(value={"RC_REF_COMPARISON_BAD_PRACTICE_BOOLEAN"})
    public static JsonValue create(@Nullable Object object) {
        if (object == null) {
            return NULL;
        }
        if (object == Boolean.TRUE) {
            return TRUE;
        }
        if (object == Boolean.FALSE) {
            return FALSE;
        }
        if (object instanceof Byte) {
            return JsonValue.create(((Byte)object).byteValue());
        }
        if (object instanceof Short) {
            return JsonValue.create(((Short)object).shortValue());
        }
        if (object instanceof Float) {
            return JsonValue.create(MathHelper.toBigDecimal((Number)((Float)object)).doubleValue());
        }
        return new JsonValue(object);
    }

    static {
        for (int i = -128; i <= 127; ++i) {
            JsonValue.NUMERIC[i - -128] = new JsonValue(i);
        }
    }
}

