/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.annotation.Nonnegative;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.nonblocking.NonBlockingStringReader;
import com.helger.base.io.stream.ByteBufferInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.io.resource.IReadableResource;
import com.helger.jaxb.IJAXBUnmarshaller;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.SAXReaderFactory;
import com.helger.xml.serialize.read.SAXReaderSettings;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public interface IJAXBReader<JAXBTYPE> {
    public boolean isUseSchema();

    default public @Nullable JAXBTYPE read(@NonNull InputSource inputSource) {
        return this.read(new SAXReaderSettings(), inputSource);
    }

    default public @Nullable JAXBTYPE read(@NonNull SAXReaderSettings sAXReaderSettings, @NonNull InputSource inputSource) {
        ValueEnforcer.notNull((Object)sAXReaderSettings, (String)"Settings");
        ValueEnforcer.notNull((Object)inputSource, (String)"InputSource");
        XMLReader xMLReader = SAXReaderFactory.createXMLReader();
        sAXReaderSettings.applyToSAXReader(xMLReader);
        return this.read(new SAXSource(xMLReader, inputSource));
    }

    default public @Nullable JAXBTYPE read(@NonNull InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        CharsetHelper.InputStreamAndCharset inputStreamAndCharset = CharsetHelper.getInputStreamAndCharsetFromBOM((InputStream)inputStream);
        if (inputStreamAndCharset.hasCharset()) {
            return this.read(StreamHelper.createReader((InputStream)inputStreamAndCharset.getInputStream(), (Charset)inputStreamAndCharset.getCharset()));
        }
        return this.read(InputSourceFactory.create((InputStream)inputStreamAndCharset.getInputStream()));
    }

    default public @Nullable JAXBTYPE read(@NonNull Reader reader) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        return this.read(InputSourceFactory.create((Reader)reader));
    }

    default public @Nullable JAXBTYPE read(@NonNull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        return this.read(InputSourceFactory.create((File)file));
    }

    default public @Nullable JAXBTYPE read(@NonNull Path path) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        return this.read(InputSourceFactory.create((Path)path));
    }

    default public @Nullable JAXBTYPE read(@NonNull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        return this.read(InputSourceFactory.create((IReadableResource)iReadableResource));
    }

    default public @Nullable JAXBTYPE read(@NonNull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"Resource");
        return this.read(iHasInputStream.getInputStream());
    }

    default public @Nullable JAXBTYPE read(byte @NonNull [] byArray) {
        ValueEnforcer.notNull((Object)byArray, (String)"XML");
        return this.read((InputStream)new NonBlockingByteArrayInputStream(byArray));
    }

    default public @Nullable JAXBTYPE read(byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull((Object)byArray, (String)"XML");
        return this.read((InputStream)new NonBlockingByteArrayInputStream(byArray, n, n2));
    }

    default public @Nullable JAXBTYPE read(@NonNull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull((Object)byteBuffer, (String)"XML");
        return this.read((InputStream)new ByteBufferInputStream(byteBuffer));
    }

    default public @Nullable JAXBTYPE read(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"XML");
        return this.read((Reader)new NonBlockingStringReader(string));
    }

    default public @Nullable JAXBTYPE read(char @NonNull [] cArray) {
        ValueEnforcer.notNull((Object)cArray, (String)"XML");
        return this.read((Reader)new NonBlockingStringReader(cArray));
    }

    public @Nullable JAXBTYPE read(@NonNull IJAXBUnmarshaller<JAXBTYPE> var1);

    default public @Nullable JAXBTYPE read(@NonNull Source source) {
        ValueEnforcer.notNull((Object)source, (String)"Source");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(source, clazz));
    }

    default public @Nullable JAXBTYPE read(@NonNull Node node) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(node, clazz));
    }

    default public @Nullable JAXBTYPE read(@NonNull XMLStreamReader xMLStreamReader) {
        ValueEnforcer.notNull((Object)xMLStreamReader, (String)"Reader");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(xMLStreamReader, clazz));
    }

    default public @Nullable JAXBTYPE read(@NonNull XMLEventReader xMLEventReader) {
        ValueEnforcer.notNull((Object)xMLEventReader, (String)"Reader");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(xMLEventReader, clazz));
    }
}

