/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.annotation.concurrent.Immutable;
import com.helger.jaxb.JAXBNamespacePrefixMapper;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import java.nio.charset.Charset;
import javax.xml.namespace.NamespaceContext;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class JAXBMarshallerHelper {
    private static final String JAXB_EXTERNAL_CLASS_NAME = "org.glassfish.jaxb.runtime.v2.runtime.MarshallerImpl";
    private static final String JAKARTA_INDENT_STRING = "org.glassfish.jaxb.indentString";
    private static final String JAKARTA_PREFIX_MAPPER = "org.glassfish.jaxb.namespacePrefixMapper";
    private static final String JAKARTA_ENCODING_HANDLER2 = "org.glassfish.jaxb.marshaller.CharacterEscapeHandler";
    private static final String JAKARTA_XML_HEADERS = "org.glassfish.jaxb.xmlHeaders";
    private static final String JAKARTA_C14N = "org.glassfish.jaxb.c14n";
    private static final String JAKARTA_OBJECT_IDENTITY_CYCLE_DETECTION = "org.glassfish.jaxb.objectIdentitityCycleDetection";

    private JAXBMarshallerHelper() {
    }

    private static void _setProperty(@NonNull Marshaller marshaller, @NonNull String string, @Nullable Object object) {
        try {
            marshaller.setProperty(string, object);
        }
        catch (PropertyException propertyException) {
            throw new IllegalArgumentException("Failed to set JAXB property '" + string + "' to " + String.valueOf(object), propertyException);
        }
    }

    private static @Nullable Object _getProperty(@NonNull Marshaller marshaller, @NonNull String string) {
        try {
            return marshaller.getProperty(string);
        }
        catch (PropertyException propertyException) {
            throw new IllegalArgumentException("Failed to get JAXB property '" + string + "'", propertyException);
        }
    }

    private static boolean _getBooleanProperty(@NonNull Marshaller marshaller, @NonNull String string) {
        return (Boolean)JAXBMarshallerHelper._getProperty(marshaller, string);
    }

    private static @Nullable String _getStringProperty(@NonNull Marshaller marshaller, @NonNull String string) {
        return (String)JAXBMarshallerHelper._getProperty(marshaller, string);
    }

    public static @Nullable String getEncoding(@NonNull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, "jaxb.encoding");
    }

    public static void setEncoding(@NonNull Marshaller marshaller, @Nullable Charset charset) {
        JAXBMarshallerHelper.setEncoding(marshaller, charset == null ? null : charset.name());
    }

    public static void setEncoding(@NonNull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.encoding", string);
    }

    public static boolean isFormattedOutput(@NonNull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, "jaxb.formatted.output");
    }

    public static void setFormattedOutput(@NonNull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.formatted.output", bl);
    }

    public static @Nullable String getSchemaLocation(@NonNull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, "jaxb.schemaLocation");
    }

    public static void setSchemaLocation(@NonNull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.schemaLocation", string);
    }

    public static @Nullable String getNoNamespaceSchemaLocation(@NonNull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, "jaxb.noNamespaceSchemaLocation");
    }

    public static void setNoNamespaceSchemaLocation(@NonNull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.noNamespaceSchemaLocation", string);
    }

    public static boolean isFragment(@NonNull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, "jaxb.fragment");
    }

    public static void setFragment(@NonNull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, "jaxb.fragment", bl);
    }

    public static @Nullable String getJakartaIndentString(@NonNull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, JAKARTA_INDENT_STRING);
    }

    public static void setJakartaIndentString(@NonNull Marshaller marshaller, @Nullable String string) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_INDENT_STRING, string);
    }

    public static @Nullable Object getJakartaCharacterEscapeHandler(@NonNull Marshaller marshaller) {
        return JAXBMarshallerHelper._getProperty(marshaller, JAKARTA_ENCODING_HANDLER2);
    }

    public static void setJakartaCharacterEscapeHandler(@NonNull Marshaller marshaller, @NonNull Object object) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_ENCODING_HANDLER2, object);
    }

    public static @Nullable JAXBNamespacePrefixMapper getJakartaNamespacePrefixMapper(@NonNull Marshaller marshaller) {
        return (JAXBNamespacePrefixMapper)((Object)JAXBMarshallerHelper._getProperty(marshaller, JAKARTA_PREFIX_MAPPER));
    }

    public static void setJakartaNamespacePrefixMapper(@NonNull Marshaller marshaller, @NonNull NamespaceContext namespaceContext) {
        JAXBNamespacePrefixMapper jAXBNamespacePrefixMapper = new JAXBNamespacePrefixMapper(namespaceContext);
        JAXBMarshallerHelper.setJakartaNamespacePrefixMapper(marshaller, jAXBNamespacePrefixMapper);
    }

    public static void setJakartaNamespacePrefixMapper(@NonNull Marshaller marshaller, @NonNull JAXBNamespacePrefixMapper jAXBNamespacePrefixMapper) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_PREFIX_MAPPER, (Object)jAXBNamespacePrefixMapper);
    }

    public static @Nullable String getJakartaXMLHeaders(@NonNull Marshaller marshaller) {
        return JAXBMarshallerHelper._getStringProperty(marshaller, JAKARTA_XML_HEADERS);
    }

    public static void setJakartaXMLHeaders(@NonNull Marshaller marshaller, @NonNull String string) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_XML_HEADERS, string);
    }

    public static boolean isJakartaCanonicalization(@NonNull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, JAKARTA_C14N);
    }

    public static void setJakartaCanonicalization(@NonNull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_C14N, bl);
    }

    public static boolean isJakartaObjectIdentityCycleDetection(@NonNull Marshaller marshaller) {
        return JAXBMarshallerHelper._getBooleanProperty(marshaller, JAKARTA_OBJECT_IDENTITY_CYCLE_DETECTION);
    }

    public static void setJakartaObjectIdentityCycleDetection(@NonNull Marshaller marshaller, boolean bl) {
        JAXBMarshallerHelper._setProperty(marshaller, JAKARTA_OBJECT_IDENTITY_CYCLE_DETECTION, bl);
    }

    public static boolean isJakartaJAXBMarshaller(@Nullable Marshaller marshaller) {
        if (marshaller == null) {
            return false;
        }
        String string = marshaller.getClass().getName();
        return string.equals(JAXB_EXTERNAL_CLASS_NAME);
    }
}

