/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.CGlobal;
import com.helger.base.classloader.ClassLoaderHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.log.IConditionalLogger;
import com.helger.base.reflection.GenericReflection;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlSchema;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@MustImplementEqualsAndHashcode
public class JAXBContextCacheKey {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBContextCacheKey.class);
    private final ICommonsList<Package> m_aPackages;
    private final WeakReference<ClassLoader> m_aClassLoader;
    private final ICommonsList<WeakReference<Class<?>>> m_aClasses;
    private final Map<String, ?> m_aProperties;
    private final String m_sEqualsHashCodeKey;

    @Deprecated(forRemoval=true, since="11.0.4")
    public JAXBContextCacheKey(@NonNull Package package_, @Nullable ClassLoader classLoader) {
        this((ICommonsList<Package>)new CommonsArrayList((Object)package_), classLoader);
    }

    public JAXBContextCacheKey(@NonNull ICommonsList<Package> iCommonsList, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"Packages");
        this.m_aPackages = (ICommonsList)iCommonsList.getClone();
        this.m_aClassLoader = new WeakReference<ClassLoader>(classLoader);
        this.m_aClasses = null;
        this.m_aProperties = null;
        this.m_sEqualsHashCodeKey = StringImplode.imploder().source(iCommonsList, Package::getName).separator(':').build();
        for (Package package_ : iCommonsList) {
            if (package_.getAnnotation(XmlSchema.class) != null || GenericReflection.getClassFromNameSafe((String)(package_.getName() + ".ObjectFactory")) != null) continue;
            LOGGER.warn("The package '" + package_.getName() + "' does not seem to be JAXB generated! Trying to create a JAXBContext anyway.");
        }
    }

    public JAXBContextCacheKey(@NonNull ICommonsList<Class<?>> iCommonsList, @Nullable Map<String, ?> map) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"Classes");
        this.m_aPackages = null;
        this.m_aClassLoader = null;
        this.m_aClasses = new CommonsArrayList(iCommonsList, WeakReference::new);
        this.m_aProperties = new CommonsHashMap(map);
        this.m_sEqualsHashCodeKey = StringImplode.imploder().source(iCommonsList, Class::getName).separator(':').build();
    }

    @ReturnsMutableCopy
    private @Nullable ICommonsList<Class<?>> _getAllClasses() {
        CommonsArrayList commonsArrayList = null;
        if (this.m_aClasses != null) {
            commonsArrayList = new CommonsArrayList();
            for (WeakReference weakReference : this.m_aClasses) {
                Class clazz = (Class)weakReference.get();
                if (clazz == null) continue;
                commonsArrayList.add((Object)clazz);
            }
        }
        return commonsArrayList;
    }

    private @Nullable ClassLoader _getClassLoader() {
        ClassLoader classLoader = null;
        if (this.m_aClassLoader != null) {
            classLoader = (ClassLoader)this.m_aClassLoader.get();
        }
        return classLoader != null ? classLoader : ClassLoaderHelper.getDefaultClassLoader();
    }

    private @NonNull JAXBContext _createFromPackageAndClassLoader(@NonNull IConditionalLogger iConditionalLogger) {
        ClassLoader classLoader = this._getClassLoader();
        iConditionalLogger.info(() -> "Creating JAXB context for packages " + StringImplode.imploder().source(this.m_aPackages, package_ -> "'" + package_.getName() + "'").separator(", ").build() + " using ClassLoader " + classLoader.toString());
        try {
            return JAXBContext.newInstance((String)this.m_sEqualsHashCodeKey, (ClassLoader)classLoader);
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context for packages " + StringImplode.imploder().source(this.m_aPackages, package_ -> "'" + package_.getName() + "'").separator(", ").build() + " using ClassLoader " + String.valueOf(classLoader);
            LOGGER.error(string + ": " + jAXBException.getMessage());
            throw new IllegalArgumentException(string, jAXBException);
        }
    }

    private @NonNull JAXBContext _createFromClassesAndProperties(@NonNull IConditionalLogger iConditionalLogger) {
        ICommonsList<Class<?>> iCommonsList = this._getAllClasses();
        iConditionalLogger.info(() -> "Creating JAXB context for classes " + StringImplode.imploder().source((Collection)iCommonsList, clazz -> "'" + clazz.getName() + "'").separator(", ").build() + (String)(this.m_aProperties.isEmpty() ? "" : " with properties " + String.valueOf(this.m_aProperties.keySet())));
        try {
            Class[] classArray = (Class[])iCommonsList.toArray((Object[])CGlobal.EMPTY_CLASS_ARRAY);
            return JAXBContext.newInstance((Class[])classArray, this.m_aProperties);
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context for classes " + StringImplode.imploder().source(iCommonsList, clazz -> "'" + clazz.getName() + "'").separator(", ").build() + (String)(this.m_aProperties.isEmpty() ? "" : " with properties " + String.valueOf(this.m_aProperties.keySet()));
            LOGGER.error(string + ": " + jAXBException.getMessage());
            throw new IllegalArgumentException(string, jAXBException);
        }
    }

    public @NonNull JAXBContext createJAXBContext(@NonNull IConditionalLogger iConditionalLogger) {
        if (this.m_aPackages != null) {
            return this._createFromPackageAndClassLoader(iConditionalLogger);
        }
        return this._createFromClassesAndProperties(iConditionalLogger);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JAXBContextCacheKey jAXBContextCacheKey = (JAXBContextCacheKey)object;
        return this.m_sEqualsHashCodeKey.equals(jAXBContextCacheKey.m_sEqualsHashCodeKey) && EqualsHelper.equals((Object)this._getClassLoader(), (Object)jAXBContextCacheKey._getClassLoader()) && EqualsHelper.equals(this.m_aProperties, jAXBContextCacheKey.m_aProperties);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sEqualsHashCodeKey).append((Object)this._getClassLoader()).append(this.m_aProperties).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("Packages", this.m_aPackages).appendIfNotNull("ClassLoader", this.m_aClassLoader).appendIfNotNull("Classes", this.m_aClasses).appendIfNotNull("Properties", this.m_aProperties).appendIfNotNull("EqualsHashCodeKey", (Object)this.m_sEqualsHashCodeKey).getToString();
    }

    public static @NonNull JAXBContextCacheKey createForPackage(@NonNull Package package_) {
        return JAXBContextCacheKey.createForPackage(package_, null);
    }

    public static @NonNull JAXBContextCacheKey createForPackage(@NonNull Package package_, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notNull((Object)package_, (String)"Package");
        return new JAXBContextCacheKey((ICommonsList<Package>)new CommonsArrayList((Object)package_), classLoader);
    }

    public static @NonNull JAXBContextCacheKey createForPackages(@NonNull ICommonsList<Package> iCommonsList) {
        return JAXBContextCacheKey.createForPackages(iCommonsList, null);
    }

    public static @NonNull JAXBContextCacheKey createForPackages(Package ... packageArray) {
        return JAXBContextCacheKey.createForPackages((ICommonsList<Package>)new CommonsArrayList((Object[])packageArray), null);
    }

    public static @NonNull JAXBContextCacheKey createForPackages(@NonNull ICommonsList<Package> iCommonsList, @Nullable ClassLoader classLoader) {
        return new JAXBContextCacheKey(iCommonsList, classLoader);
    }

    public static @NonNull JAXBContextCacheKey createForClass(@NonNull Class<?> clazz) {
        return JAXBContextCacheKey.createForClass(clazz, null);
    }

    public static @NonNull JAXBContextCacheKey createForClass(@NonNull Class<?> clazz, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        Package package_ = clazz.getPackage();
        if (package_.getAnnotation(XmlSchema.class) != null) {
            return JAXBContextCacheKey.createForPackage(package_, classLoader);
        }
        return new JAXBContextCacheKey((ICommonsList<Class<?>>)new CommonsArrayList(clazz), (Map)null);
    }

    public static @NonNull JAXBContextCacheKey createForClasses(@NonNull ICommonsList<Class<?>> iCommonsList) {
        return JAXBContextCacheKey.createForClasses(iCommonsList, null);
    }

    public static @NonNull JAXBContextCacheKey createForClasses(Class<?> ... classArray) {
        return JAXBContextCacheKey.createForClasses(new CommonsArrayList((Object[])classArray), null);
    }

    public static @NonNull JAXBContextCacheKey createForClasses(@NonNull ICommonsList<Class<?>> iCommonsList, @Nullable Map<String, ?> map) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"Classes");
        return new JAXBContextCacheKey(iCommonsList, map);
    }
}

