/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsImmutableObject;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.callback.CallbackList;
import com.helger.base.callback.ICallback;
import com.helger.base.callback.exception.IExceptionCallback;
import com.helger.base.classloader.IHasClassLoader;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHex;
import com.helger.base.system.ENewLineMode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.io.resource.ClassPathResource;
import com.helger.jaxb.IJAXBMarshaller;
import com.helger.jaxb.IJAXBReader;
import com.helger.jaxb.IJAXBUnmarshaller;
import com.helger.jaxb.IJAXBValidator;
import com.helger.jaxb.IJAXBWriter;
import com.helger.jaxb.JAXBContextCache;
import com.helger.jaxb.JAXBContextCacheKey;
import com.helger.jaxb.JAXBMarshallerHelper;
import com.helger.jaxb.LoggingJAXBReadExceptionHandler;
import com.helger.jaxb.LoggingJAXBWriteExceptionHandler;
import com.helger.jaxb.builder.JAXBBuilderDefaultSettings;
import com.helger.jaxb.validation.WrappedCollectingValidationEventHandler;
import com.helger.xml.schema.XMLSchemaCache;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
public class GenericJAXBMarshaller<JAXBTYPE>
implements IHasClassLoader,
IJAXBReader<JAXBTYPE>,
IJAXBWriter<JAXBTYPE>,
IJAXBValidator<JAXBTYPE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericJAXBMarshaller.class);
    private final Class<JAXBTYPE> m_aType;
    private final ICommonsList<ClassPathResource> m_aXSDs = new CommonsArrayList();
    private final Function<? super JAXBTYPE, ? extends JAXBElement<JAXBTYPE>> m_aJAXBElementWrapper;
    private ValidationEventHandler m_aEventHandler = JAXBBuilderDefaultSettings.getDefaultValidationEventHandler();
    private boolean m_bFormattedOutput = JAXBBuilderDefaultSettings.isDefaultFormattedOutput();
    private NamespaceContext m_aNSContext = JAXBBuilderDefaultSettings.getDefaultNamespaceContext();
    private Charset m_aCharset = JAXBBuilderDefaultSettings.getDefaultCharset();
    private String m_sIndentString = JAXBBuilderDefaultSettings.getDefaultIndentString();
    private boolean m_bUseSchema = JAXBBuilderDefaultSettings.isDefaultUseSchema();
    private String m_sSchemaLocation = JAXBBuilderDefaultSettings.getDefaultSchemaLocation();
    private String m_sNoNamespaceSchemaLocation = JAXBBuilderDefaultSettings.getDefaultNoNamespaceSchemaLocation();
    private boolean m_bUseContextCache = JAXBBuilderDefaultSettings.isDefaultUseContextCache();
    private final XMLWriterSettings m_aXWS = new XMLWriterSettings().setNewLineMode(ENewLineMode.DEFAULT).setIncorrectCharacterHandling(EXMLIncorrectCharacterHandling.DO_NOT_WRITE_LOG_WARNING);
    private WeakReference<ClassLoader> m_aClassLoader;
    private final CallbackList<IExceptionCallback<JAXBException>> m_aReadExceptionCallbacks = new CallbackList();
    private final CallbackList<IExceptionCallback<JAXBException>> m_aWriteExceptionCallbacks = new CallbackList();

    public GenericJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, @Nonnull QName qName) {
        this(clazz, GenericJAXBMarshaller.createSimpleJAXBElement(qName, clazz));
    }

    public GenericJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, @Nonnull Function<? super JAXBTYPE, ? extends JAXBElement<JAXBTYPE>> function) {
        this(clazz, null, function);
    }

    public GenericJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, @Nullable List<? extends ClassPathResource> list, @Nonnull Function<? super JAXBTYPE, ? extends JAXBElement<JAXBTYPE>> function) {
        this.m_aType = (Class)ValueEnforcer.notNull(clazz, (String)"Type");
        if (list != null) {
            ValueEnforcer.notEmptyNoNullValue(list, (String)"XSDs");
            this.m_aXSDs.addAll(list);
            for (ClassPathResource classPathResource : this.m_aXSDs) {
                ValueEnforcer.isTrue((boolean)classPathResource.hasClassLoader(), () -> "ClassPathResource " + String.valueOf(classPathResource) + " should define its ClassLoader for OSGI handling!");
            }
        }
        this.m_aJAXBElementWrapper = (Function)ValueEnforcer.notNull(function, (String)"JAXBElementWrapper");
        this.m_aClassLoader = new WeakReference<ClassLoader>(clazz.getClassLoader());
        this.m_aReadExceptionCallbacks.add((ICallback)LoggingJAXBReadExceptionHandler.INSTANCE);
        this.m_aWriteExceptionCallbacks.add((ICallback)LoggingJAXBWriteExceptionHandler.INSTANCE);
    }

    @Nonnull
    protected final Class<JAXBTYPE> getType() {
        return this.m_aType;
    }

    @Nullable
    public final ClassLoader getClassLoader() {
        return (ClassLoader)this.m_aClassLoader.get();
    }

    @Nullable
    public final ValidationEventHandler getValidationEventHandler() {
        return this.m_aEventHandler;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setValidationEventHandler(@Nullable ValidationEventHandler validationEventHandler) {
        this.m_aEventHandler = validationEventHandler;
        return this;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setCollectErrors(@Nonnull ErrorList errorList) {
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        return this.setValidationEventHandler(new WrappedCollectingValidationEventHandler(errorList));
    }

    @Override
    @Nullable
    public final NamespaceContext getNamespaceContext() {
        return this.m_aNSContext;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setNamespaceContext(@Nullable NamespaceContext namespaceContext) {
        this.m_aNSContext = namespaceContext;
        return this;
    }

    @Override
    public final boolean isFormattedOutput() {
        return this.m_bFormattedOutput;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setFormattedOutput(boolean bl) {
        this.m_bFormattedOutput = bl;
        return this;
    }

    @Override
    @Nullable
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setCharset(@Nullable Charset charset) {
        this.m_aCharset = charset;
        return this;
    }

    @Override
    @Nullable
    public final String getIndentString() {
        return this.m_sIndentString;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setIndentString(@Nullable String string) {
        this.m_sIndentString = string;
        return this;
    }

    @Override
    public final boolean isUseSchema() {
        return this.m_bUseSchema;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setUseSchema(boolean bl) {
        this.m_bUseSchema = bl;
        return this;
    }

    @Override
    @Nullable
    public final String getSchemaLocation() {
        return this.m_sSchemaLocation;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setSchemaLocation(@Nullable String string) {
        this.m_sSchemaLocation = string;
        return this;
    }

    @Override
    @Nullable
    public final String getNoNamespaceSchemaLocation() {
        return this.m_sNoNamespaceSchemaLocation;
    }

    @Nonnull
    @ReturnsMutableObject
    public XMLWriterSettings xmlWriterSettings() {
        XMLWriterSettings xMLWriterSettings = this.m_aXWS;
        xMLWriterSettings.setNamespaceContext(this.getNamespaceContext()).setIndent(this.isFormattedOutput() ? EXMLSerializeIndent.INDENT_AND_ALIGN : EXMLSerializeIndent.NONE);
        if (this.hasIndentString()) {
            xMLWriterSettings.setIndentationString(this.getIndentString());
        }
        if (this.hasCharset()) {
            xMLWriterSettings.setCharset(this.getCharset());
        }
        return xMLWriterSettings;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> withXMLWriterSettings(@Nonnull Consumer<? super XMLWriterSettings> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        consumer.accept((XMLWriterSettings)this.m_aXWS);
        return this;
    }

    @Override
    @Nonnull
    @ReturnsImmutableObject
    public IXMLWriterSettings getXMLWriterSettings() {
        return this.xmlWriterSettings();
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setNoNamespaceSchemaLocation(@Nullable String string) {
        this.m_sNoNamespaceSchemaLocation = string;
        return this;
    }

    public final boolean isUseContextCache() {
        return this.m_bUseContextCache;
    }

    @Nonnull
    public final GenericJAXBMarshaller<JAXBTYPE> setUseContextCache(boolean bl) {
        this.m_bUseContextCache = bl;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IExceptionCallback<JAXBException>> readExceptionCallbacks() {
        return this.m_aReadExceptionCallbacks;
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IExceptionCallback<JAXBException>> writeExceptionCallbacks() {
        return this.m_aWriteExceptionCallbacks;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final ICommonsList<ClassPathResource> getOriginalXSDs() {
        return (ICommonsList)this.m_aXSDs.getClone();
    }

    @Nullable
    @OverrideOnDemand
    protected Schema createValidationSchema() {
        if (!this.m_bUseSchema) {
            return null;
        }
        if (this.m_aXSDs.isEmpty()) {
            return null;
        }
        return XMLSchemaCache.getInstanceOfClassLoader((ClassLoader)this.getClassLoader()).getSchema(this.m_aXSDs);
    }

    @Nonnull
    @OverrideOnDemand
    protected JAXBContext getJAXBContext(@Nullable ClassLoader classLoader) throws JAXBException {
        Package package_ = this.m_aType.getPackage();
        if (this.m_bUseContextCache) {
            return (JAXBContext)JAXBContextCache.getInstance().getFromCache(JAXBContextCacheKey.createForPackage(package_, classLoader));
        }
        return JAXBContext.newInstance((String)package_.getName(), (ClassLoader)classLoader);
    }

    @Nonnull
    private Unmarshaller _createUnmarshaller(@Nullable ClassLoader classLoader) throws JAXBException {
        Schema schema;
        JAXBContext jAXBContext = this.getJAXBContext(classLoader);
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        if (this.m_aEventHandler != null) {
            unmarshaller.setEventHandler(this.m_aEventHandler);
        }
        if ((schema = this.createValidationSchema()) != null) {
            unmarshaller.setSchema(schema);
        }
        return unmarshaller;
    }

    @OverrideOnDemand
    protected void customizeUnmarshaller(@Nonnull Unmarshaller unmarshaller) {
    }

    @Override
    @Nullable
    public final JAXBTYPE read(@Nonnull IJAXBUnmarshaller<JAXBTYPE> iJAXBUnmarshaller) {
        ValueEnforcer.notNull(iJAXBUnmarshaller, (String)"Handler");
        try {
            Unmarshaller unmarshaller = this._createUnmarshaller(this.getClassLoader());
            this.customizeUnmarshaller(unmarshaller);
            return (JAXBTYPE)iJAXBUnmarshaller.doUnmarshal(unmarshaller, this.m_aType).getValue();
        }
        catch (JAXBException jAXBException) {
            this.m_aReadExceptionCallbacks.forEach(iExceptionCallback -> iExceptionCallback.onException((Throwable)jAXBException));
            return null;
        }
    }

    @Nonnull
    private Marshaller _createMarshaller(@Nullable ClassLoader classLoader) throws JAXBException {
        Schema schema;
        JAXBContext jAXBContext = this.getJAXBContext(classLoader);
        Marshaller marshaller = jAXBContext.createMarshaller();
        if (this.m_aEventHandler != null) {
            marshaller.setEventHandler(this.m_aEventHandler);
        }
        if (this.m_aNSContext != null) {
            try {
                JAXBMarshallerHelper.setJakartaNamespacePrefixMapper(marshaller, this.m_aNSContext);
            }
            catch (Exception | NoClassDefFoundError throwable) {
                LOGGER.error("Failed to set the namespace context " + String.valueOf(this.m_aNSContext) + ": " + throwable.getClass().getName() + " -- " + throwable.getMessage());
            }
        }
        JAXBMarshallerHelper.setFormattedOutput(marshaller, this.m_bFormattedOutput);
        if (this.m_aCharset != null) {
            JAXBMarshallerHelper.setEncoding(marshaller, this.m_aCharset);
        }
        if (this.m_sIndentString != null) {
            JAXBMarshallerHelper.setJakartaIndentString(marshaller, this.m_sIndentString);
        }
        if (this.m_sSchemaLocation != null) {
            JAXBMarshallerHelper.setSchemaLocation(marshaller, this.m_sSchemaLocation);
        }
        if (this.m_sNoNamespaceSchemaLocation != null) {
            JAXBMarshallerHelper.setNoNamespaceSchemaLocation(marshaller, this.m_sNoNamespaceSchemaLocation);
        }
        if ((schema = this.createValidationSchema()) != null) {
            marshaller.setSchema(schema);
        }
        return marshaller;
    }

    @OverrideOnDemand
    protected void customizeMarshaller(@Nonnull Marshaller marshaller) {
    }

    @Override
    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull IJAXBMarshaller<JAXBTYPE> iJAXBMarshaller) {
        ValueEnforcer.notNull(JAXBTYPE, (String)"Object");
        ValueEnforcer.notNull(iJAXBMarshaller, (String)"MarshallerFunc");
        try {
            Marshaller marshaller = this._createMarshaller(this.getClassLoader());
            this.customizeMarshaller(marshaller);
            JAXBElement<JAXBTYPE> jAXBElement = this.m_aJAXBElementWrapper.apply(JAXBTYPE);
            iJAXBMarshaller.doMarshal(marshaller, jAXBElement);
            return ESuccess.SUCCESS;
        }
        catch (JAXBException jAXBException) {
            this.m_aWriteExceptionCallbacks.forEach(iExceptionCallback -> iExceptionCallback.onException((Throwable)jAXBException));
            return ESuccess.FAILURE;
        }
    }

    @OverrideOnDemand
    protected void customizeMarshallerForValidation(@Nonnull Marshaller marshaller) {
    }

    @Override
    public void validate(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull ErrorList errorList) {
        ValueEnforcer.notNull(JAXBTYPE, (String)"Object");
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        WrappedCollectingValidationEventHandler wrappedCollectingValidationEventHandler = new WrappedCollectingValidationEventHandler(errorList);
        try {
            Marshaller marshaller = this._createMarshaller(this.getClassLoader());
            marshaller.setEventHandler((ValidationEventHandler)wrappedCollectingValidationEventHandler);
            this.customizeMarshallerForValidation(marshaller);
            if (marshaller.getSchema() == null) {
                LOGGER.warn("Running validation on JAXB object of type " + JAXBTYPE.getClass().getName() + " makes no sense, because no XML Schema is provided");
            }
            JAXBElement<JAXBTYPE> jAXBElement = this.m_aJAXBElementWrapper.apply(JAXBTYPE);
            marshaller.marshal(jAXBElement, (ContentHandler)new DefaultHandler());
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Type", this.m_aType).append("XSDs", this.m_aXSDs).append("JAXBElementWrapper", this.m_aJAXBElementWrapper).append("EventHandler", (Object)this.m_aEventHandler).append("FormattedOutput", this.m_bFormattedOutput).append("NSContext", (Object)this.m_aNSContext).append("Charset", (Object)this.m_aCharset).append("IndentString", this.m_sIndentString == null ? null : StringHex.getHexEncoded((String)this.m_sIndentString, (Charset)StandardCharsets.ISO_8859_1)).append("SchemaLocation", (Object)this.m_sSchemaLocation).append("NoNamespaceSchemaLocation", (Object)this.m_sNoNamespaceSchemaLocation).append("UseContextCache", this.m_bUseContextCache).append("ClassLoader", this.m_aClassLoader).append("ReadExceptionHandlers", this.m_aReadExceptionCallbacks).append("WriteExceptionHandlers", this.m_aWriteExceptionCallbacks).getToString();
    }

    @Nonnull
    public static <T> Function<T, JAXBElement<T>> createSimpleJAXBElement(@Nonnull QName qName, @Nonnull Class<T> clazz) {
        return object -> new JAXBElement(qName, clazz, null, object);
    }
}

