/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.callback.exception.IExceptionCallback;
import jakarta.annotation.Nonnull;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

@Immutable
public class LoggingJAXBReadExceptionHandler
implements IExceptionCallback<JAXBException> {
    public static final LoggingJAXBReadExceptionHandler INSTANCE = new LoggingJAXBReadExceptionHandler();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingJAXBReadExceptionHandler.class);

    public void onException(@Nonnull JAXBException jAXBException) {
        if (jAXBException instanceof UnmarshalException) {
            Throwable throwable = jAXBException.getLinkedException();
            if (throwable instanceof SAXParseException) {
                LOGGER.error("Failed to parse XML document: " + throwable.getMessage());
            } else {
                LOGGER.error("Unmarshal exception reading document", (Throwable)jAXBException);
            }
        } else {
            LOGGER.warn("JAXB Exception reading document", (Throwable)jAXBException);
        }
    }
}

