/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.jaxb.validation.LoggingValidationEventHandler;
import com.helger.xml.serialize.write.XMLWriterSettings;
import jakarta.xml.bind.ValidationEventHandler;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.NamespaceContext;

@ThreadSafe
public final class JAXBBuilderDefaultSettings {
    public static final boolean DEFAULT_USE_CONTEXT_CACHE = true;
    public static final ValidationEventHandler DEFAULT_VALIDATION_EVENT_HANDLER = LoggingValidationEventHandler.DEFAULT_INSTANCE;
    public static final boolean DEFAULT_FORMATTED_OUTPUT = false;
    public static final Charset DEFAULT_CHARSET = XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bUseContextCache = true;
    @GuardedBy(value="RW_LOCK")
    private static ValidationEventHandler s_aEventHandler = DEFAULT_VALIDATION_EVENT_HANDLER;
    @GuardedBy(value="RW_LOCK")
    private static NamespaceContext s_aNamespaceContext;
    @GuardedBy(value="RW_LOCK")
    private static boolean s_bFormattedOutput;
    @GuardedBy(value="RW_LOCK")
    private static Charset s_aCharset;
    @GuardedBy(value="RW_LOCK")
    private static String s_sIndentString;
    @GuardedBy(value="RW_LOCK")
    private static String s_sSchemaLocation;
    @GuardedBy(value="RW_LOCK")
    private static String s_sNoNamespaceSchemaLocation;

    private JAXBBuilderDefaultSettings() {
    }

    public static void setDefaultUseContextCache(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bUseContextCache = bl;
        });
    }

    public static boolean isDefaultUseContextCache() {
        return RW_LOCK.readLockedBoolean(() -> s_bUseContextCache);
    }

    public static void setDefaultValidationEventHandler(@Nullable ValidationEventHandler validationEventHandler) {
        RW_LOCK.writeLocked(() -> {
            s_aEventHandler = validationEventHandler;
        });
    }

    @Nullable
    public static ValidationEventHandler getDefaultValidationEventHandler() {
        return (ValidationEventHandler)RW_LOCK.readLockedGet(() -> s_aEventHandler);
    }

    public static void setDefaultNamespaceContext(@Nullable NamespaceContext namespaceContext) {
        RW_LOCK.writeLocked(() -> {
            s_aNamespaceContext = namespaceContext;
        });
    }

    @Nullable
    public static NamespaceContext getDefaultNamespaceContext() {
        return (NamespaceContext)RW_LOCK.readLockedGet(() -> s_aNamespaceContext);
    }

    public static void setDefaultFormattedOutput(boolean bl) {
        RW_LOCK.writeLocked(() -> {
            s_bFormattedOutput = bl;
        });
    }

    public static boolean isDefaultFormattedOutput() {
        return RW_LOCK.readLockedBoolean(() -> s_bFormattedOutput);
    }

    public static void setDefaultCharset(@Nullable Charset charset) {
        RW_LOCK.writeLocked(() -> {
            s_aCharset = charset;
        });
    }

    @Nullable
    public static Charset getDefaultCharset() {
        return (Charset)RW_LOCK.readLockedGet(() -> s_aCharset);
    }

    public static void setDefaultIndentString(@Nullable String string) {
        RW_LOCK.writeLocked(() -> {
            s_sIndentString = string;
        });
    }

    @Nullable
    public static String getDefaultIndentString() {
        return (String)RW_LOCK.readLockedGet(() -> s_sIndentString);
    }

    public static void setDefaultSchemaLocation(@Nullable String string) {
        RW_LOCK.writeLocked(() -> {
            s_sSchemaLocation = string;
        });
    }

    @Nullable
    public static String getDefaultSchemaLocation() {
        return (String)RW_LOCK.readLockedGet(() -> s_sSchemaLocation);
    }

    public static void setDefaultNoNamespaceSchemaLocation(@Nullable String string) {
        RW_LOCK.writeLocked(() -> {
            s_sNoNamespaceSchemaLocation = string;
        });
    }

    @Nullable
    public static String getDefaultNoNamespaceSchemaLocation() {
        return (String)RW_LOCK.readLockedGet(() -> s_sNoNamespaceSchemaLocation);
    }

    static {
        s_bFormattedOutput = false;
        s_aCharset = DEFAULT_CHARSET;
    }
}

