/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.list.IErrorList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.xml.EXMLParserProperty;
import com.helger.xml.schema.XMLSchemaValidationHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;

@MustImplementEqualsAndHashcode
public interface IJAXBDocumentType {
    public Schema getSchema();

    @Nonnull
    public Class<?> getImplementationClass();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ClassPathResource> getAllXSDResources();

    @Nonnull
    public String getNamespaceURI();

    @Nonnull
    @Nonempty
    public String getLocalName();

    @Nullable
    default public Validator getValidator() {
        return this.getValidator(null);
    }

    @Nullable
    default public Validator getValidator(@Nullable Locale locale) {
        Schema schema = this.getSchema();
        if (schema != null) {
            Validator validator = schema.newValidator();
            if (!1.$assertionsDisabled && validator == null) {
                throw new AssertionError();
            }
            if (locale != null) {
                EXMLParserProperty.GENERAL_LOCALE.applyTo(validator, (Object)locale);
            }
            return validator;
        }
        return null;
    }

    @Nullable
    default public IErrorList validateXML(@Nonnull IReadableResource iReadableResource) {
        Schema schema = this.getSchema();
        return schema == null ? null : XMLSchemaValidationHelper.validate((Schema)schema, (IReadableResource)iReadableResource);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

