/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.callback.ICallback;
import com.helger.commons.lang.GenericReflection;
import com.helger.jaxb.LoggingJAXBWriteExceptionHandler;
import com.helger.jaxb.builder.AbstractJAXBBuilder;
import com.helger.jaxb.builder.IJAXBDocumentType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;

@NotThreadSafe
public abstract class AbstractWritingJAXBBuilder<JAXBTYPE, IMPLTYPE extends AbstractWritingJAXBBuilder<JAXBTYPE, IMPLTYPE>>
extends AbstractJAXBBuilder<IMPLTYPE> {
    private Consumer<? super Marshaller> m_aMarshallerCustomizer;

    protected AbstractWritingJAXBBuilder(@Nonnull IJAXBDocumentType iJAXBDocumentType) {
        super(iJAXBDocumentType);
        this.exceptionCallbacks().add((ICallback)new LoggingJAXBWriteExceptionHandler());
    }

    @Nullable
    public final Consumer<? super Marshaller> getMarshallerCustomizer() {
        return this.m_aMarshallerCustomizer;
    }

    @Nonnull
    public final IMPLTYPE setMarshallerCustomizer(@Nullable Consumer<? super Marshaller> consumer) {
        this.m_aMarshallerCustomizer = consumer;
        return (IMPLTYPE)((AbstractWritingJAXBBuilder)this.thisAsT());
    }

    @Nonnull
    @OverrideOnDemand
    protected Marshaller createMarshaller() throws JAXBException {
        JAXBContext jAXBContext = this.getJAXBContext();
        Marshaller marshaller = jAXBContext.createMarshaller();
        Schema schema = this.getSchema();
        if (schema != null) {
            marshaller.setSchema(schema);
        }
        return marshaller;
    }

    @Nonnull
    protected <T> JAXBElement<T> createJAXBElement(@Nonnull T t) {
        return new JAXBElement(new QName(this.m_aDocType.getNamespaceURI(), this.m_aDocType.getLocalName()), (Class)GenericReflection.uncheckedCast(t.getClass()), null, t);
    }
}

