/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.ByteBufferInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.jaxb.IJAXBUnmarshaller;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.SAXReaderFactory;
import com.helger.xml.serialize.read.SAXReaderSettings;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public interface IJAXBReader<JAXBTYPE> {
    @Nullable
    default public JAXBTYPE read(@Nonnull InputSource inputSource) {
        return this.read(new SAXReaderSettings(), inputSource);
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull SAXReaderSettings sAXReaderSettings, @Nonnull InputSource inputSource) {
        ValueEnforcer.notNull((Object)sAXReaderSettings, (String)"Settings");
        ValueEnforcer.notNull((Object)inputSource, (String)"InputSource");
        XMLReader xMLReader = SAXReaderFactory.createXMLReader();
        sAXReaderSettings.applyToSAXReader(xMLReader);
        return this.read(new SAXSource(xMLReader, inputSource));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        CharsetHelper.InputStreamAndCharset inputStreamAndCharset = CharsetHelper.getInputStreamAndCharsetFromBOM((InputStream)inputStream);
        if (inputStreamAndCharset.hasCharset()) {
            return this.read(StreamHelper.createReader((InputStream)inputStreamAndCharset.getInputStream(), (Charset)inputStreamAndCharset.getCharset()));
        }
        return this.read(InputSourceFactory.create((InputStream)inputStreamAndCharset.getInputStream()));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull Reader reader) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        return this.read(InputSourceFactory.create((Reader)reader));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        return this.read(InputSourceFactory.create((File)file));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull Path path) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        return this.read(InputSourceFactory.create((Path)path));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        return this.read(InputSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"Resource");
        return this.read(iHasInputStream.getInputStream());
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull((Object)byArray, (String)"XML");
        return this.read((InputStream)new NonBlockingByteArrayInputStream(byArray));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull((Object)byArray, (String)"XML");
        return this.read((InputStream)new NonBlockingByteArrayInputStream(byArray, n, n2));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull((Object)byteBuffer, (String)"XML");
        return this.read((InputStream)new ByteBufferInputStream(byteBuffer));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"XML");
        return this.read((Reader)new NonBlockingStringReader(string));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull char[] cArray) {
        ValueEnforcer.notNull((Object)cArray, (String)"XML");
        return this.read((Reader)new NonBlockingStringReader(cArray));
    }

    @Nullable
    public JAXBTYPE read(@Nonnull IJAXBUnmarshaller<JAXBTYPE> var1);

    @Nullable
    default public JAXBTYPE read(@Nonnull Source source) {
        ValueEnforcer.notNull((Object)source, (String)"Source");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(source, clazz));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull Node node) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(node, clazz));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull XMLStreamReader xMLStreamReader) {
        ValueEnforcer.notNull((Object)xMLStreamReader, (String)"Reader");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(xMLStreamReader, clazz));
    }

    @Nullable
    default public JAXBTYPE read(@Nonnull XMLEventReader xMLEventReader) {
        ValueEnforcer.notNull((Object)xMLEventReader, (String)"Reader");
        return this.read((Unmarshaller unmarshaller, Class<JAXBTYPE> clazz) -> unmarshaller.unmarshal(xMLEventReader, clazz));
    }
}

