/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.builder;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.exception.IExceptionCallback;
import com.helger.commons.lang.IHasClassLoader;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.jaxb.JAXBContextCache;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.jaxb.builder.JAXBBuilderDefaultSettings;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.validation.Schema;

@NotThreadSafe
public abstract class AbstractJAXBBuilder<IMPLTYPE extends AbstractJAXBBuilder<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE>,
IHasClassLoader {
    protected final IJAXBDocumentType m_aDocType;
    private final WeakReference<ClassLoader> m_aClassLoader;
    private boolean m_bUseJAXBContextCache = JAXBBuilderDefaultSettings.isDefaultUseContextCache();
    private boolean m_bUseSchema = true;
    private final CallbackList<IExceptionCallback<JAXBException>> m_aExceptionCallbacks = new CallbackList();

    protected AbstractJAXBBuilder(@Nonnull IJAXBDocumentType iJAXBDocumentType) {
        this.m_aDocType = (IJAXBDocumentType)ValueEnforcer.notNull((Object)iJAXBDocumentType, (String)"DocType");
        this.m_aClassLoader = new WeakReference<ClassLoader>(iJAXBDocumentType.getImplementationClass().getClassLoader());
    }

    @Nonnull
    public final IJAXBDocumentType getJAXBDocumentType() {
        return this.m_aDocType;
    }

    @Nullable
    public final ClassLoader getClassLoader() {
        return (ClassLoader)this.m_aClassLoader.get();
    }

    public final boolean isUseJAXBContextCache() {
        return this.m_bUseJAXBContextCache;
    }

    @Nonnull
    public final IMPLTYPE setUseJAXBContextCache(boolean bl) {
        this.m_bUseJAXBContextCache = bl;
        return (IMPLTYPE)((AbstractJAXBBuilder)this.thisAsT());
    }

    public final boolean isUseSchema() {
        return this.m_bUseSchema;
    }

    @Nonnull
    public final IMPLTYPE setUseSchema(boolean bl) {
        this.m_bUseSchema = bl;
        return (IMPLTYPE)((AbstractJAXBBuilder)this.thisAsT());
    }

    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IExceptionCallback<JAXBException>> exceptionCallbacks() {
        return this.m_aExceptionCallbacks;
    }

    @Nullable
    protected final Schema getSchema() {
        if (this.m_bUseSchema) {
            return this.m_aDocType.getSchema();
        }
        return null;
    }

    @Nonnull
    @OverrideOnDemand
    protected JAXBContext getJAXBContext() throws JAXBException {
        if (this.m_bUseJAXBContextCache) {
            return JAXBContextCache.getInstance().getFromCache(this.m_aDocType.getImplementationClass(), this.getClassLoader());
        }
        return JAXBContext.newInstance((String)this.m_aDocType.getImplementationClass().getPackage().getName(), (ClassLoader)this.getClassLoader());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("DocType", (Object)this.m_aDocType).appendIfNotNull("ClassLoader", this.m_aClassLoader).append("UseJAXBContextCache", this.m_bUseJAXBContextCache).append("UseSchema", this.m_bUseSchema).append("ExceptionHandler", this.m_aExceptionCallbacks).getToString();
    }
}

