/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.adapter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTWebDateHelper;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterOffsetTime
extends XmlAdapter<String, OffsetTime> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterOffsetTime.class);
    private static Function<LocalTime, ZoneOffset> s_aZOSupplier = localTime -> ZoneOffset.UTC;

    @Nonnull
    public static Function<LocalTime, ZoneOffset> getFallbackZoneOffsetSupplier() {
        return s_aZOSupplier;
    }

    @Nonnull
    public static void setFallbackZoneOffsetSupplier(@Nonnull Function<LocalTime, ZoneOffset> function) {
        ValueEnforcer.notNull(function, (String)"ZoneOffsetSupplier");
        s_aZOSupplier = function;
    }

    public OffsetTime unmarshal(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        OffsetTime offsetTime = PDTWebDateHelper.getOffsetTimeFromXSD((String)string2);
        if (offsetTime == null) {
            LocalTime localTime = PDTWebDateHelper.getLocalTimeFromXSD((String)string2);
            if (localTime != null) {
                offsetTime = OffsetTime.of(localTime, AdapterOffsetTime.getFallbackZoneOffsetSupplier().apply(localTime));
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to parse '" + string + "' to an OffsetTime");
            }
        }
        return offsetTime;
    }

    public String marshal(@Nullable OffsetTime offsetTime) {
        return PDTWebDateHelper.getAsStringXSD((OffsetTime)offsetTime);
    }
}

