/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.adapter;

import com.helger.commons.datetime.PDTWebDateHelper;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterZonedDateTime
extends XmlAdapter<String, ZonedDateTime> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterZonedDateTime.class);

    public ZonedDateTime unmarshal(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        ZonedDateTime zonedDateTime = PDTWebDateHelper.getZonedDateTimeFromXSD((String)string2);
        if (zonedDateTime == null) {
            LocalDateTime localDateTime = PDTWebDateHelper.getLocalDateTimeFromXSD((String)string2);
            if (localDateTime != null) {
                zonedDateTime = ZonedDateTime.of(localDateTime, ZoneOffset.UTC);
            } else {
                LOGGER.warn("Failed to parse '" + string + "' to a ZonedDateTime");
            }
        }
        return zonedDateTime;
    }

    public String marshal(@Nullable ZonedDateTime zonedDateTime) {
        return PDTWebDateHelper.getAsStringXSD((ZonedDateTime)zonedDateTime);
    }
}

