/*
 * Decompiled with CFR 0.152.
 */
package com.helger.io.resourceprovider;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.FileSystemResource;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.IWritableResource;
import com.helger.io.resource.URLResource;
import com.helger.io.resourceprovider.IWritableResourceProvider;
import java.io.File;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class FileSystemResourceProvider
implements IWritableResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemResourceProvider.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final File m_aBasePath;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bCanReadRelativePaths = false;

    public FileSystemResourceProvider() {
        this((File)null);
    }

    public FileSystemResourceProvider(@NonNull String string) {
        this(new File(string));
    }

    public FileSystemResourceProvider(@Nullable File file) {
        if (file != null) {
            ValueEnforcer.isTrue((boolean)file.exists(), () -> "Passed base path '" + String.valueOf(file) + "' does not exist!");
            ValueEnforcer.isTrue((boolean)file.isDirectory(), () -> "Passed base path '" + String.valueOf(file) + "' is not a directory!");
            if (!file.canRead()) {
                LOGGER.warn("Cannot read passed base path '" + String.valueOf(file) + "'!");
            }
            if (!file.canWrite()) {
                LOGGER.warn("Cannot write passed base path '" + String.valueOf(file) + "'!");
            }
            if (!file.canExecute()) {
                LOGGER.warn("Cannot execute in passed base path '" + String.valueOf(file) + "'!");
            }
        }
        this.m_aBasePath = file;
    }

    public final @Nullable File getBasePath() {
        return this.m_aBasePath;
    }

    public final boolean isCanReadRelativePaths() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bCanReadRelativePaths);
    }

    public final @NonNull FileSystemResourceProvider setCanReadRelativePaths(boolean bl) {
        this.m_aRWLock.writeLockedBoolean(() -> {
            this.m_bCanReadRelativePaths = bl;
            return this.m_bCanReadRelativePaths;
        });
        return this;
    }

    private @NonNull File _getFile(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        return this.m_aBasePath == null ? new File(string) : new File(this.m_aBasePath, string);
    }

    @Override
    public boolean supportsReading(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        if (ClassPathResource.isExplicitClassPathResource(string)) {
            return false;
        }
        if (URLResource.isExplicitURLResource(string)) {
            return false;
        }
        if (this.isCanReadRelativePaths()) {
            return true;
        }
        return this._getFile(string).isAbsolute();
    }

    @Override
    public boolean supportsWriting(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        if (ClassPathResource.isExplicitClassPathResource(string)) {
            return false;
        }
        return !URLResource.isExplicitURLResource(string);
    }

    @Override
    public @NonNull IReadableResource getReadableResource(@NonNull String string) {
        return new FileSystemResource(this._getFile(string));
    }

    @Override
    public @NonNull IWritableResource getWritableResource(@NonNull String string) {
        return new FileSystemResource(this._getFile(string));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileSystemResourceProvider fileSystemResourceProvider = (FileSystemResourceProvider)object;
        return EqualsHelper.equals((Object)this.m_aBasePath, (Object)fileSystemResourceProvider.m_aBasePath) && this.m_bCanReadRelativePaths == fileSystemResourceProvider.m_bCanReadRelativePaths;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aBasePath).append(this.m_bCanReadRelativePaths).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("BasePath", (Object)this.m_aBasePath).append("CanReadRelativePaths", this.m_bCanReadRelativePaths).getToString();
    }
}

