/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.csp;

import com.helger.annotation.Nonempty;
import com.helger.base.codec.RFC5234Helper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.http.csp.AbstractCSPSourceList;
import com.helger.http.csp.ICSPDirective;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class CSPDirective
implements ICSPDirective {
    private final String m_sName;
    private final String m_sValue;

    public static boolean isValidName(@Nullable String string) {
        char[] cArray;
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        for (char c : cArray = string.toCharArray()) {
            if (RFC5234Helper.isAlpha((int)c) || RFC5234Helper.isDigit((int)c) || c == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidValue(@Nullable String string) {
        char[] cArray;
        if (StringHelper.isEmpty((String)string)) {
            return true;
        }
        for (char c : cArray = string.toCharArray()) {
            if (RFC5234Helper.isWSP((int)c) || RFC5234Helper.isVChar((int)c) && c != ';' && c != ',') continue;
            return false;
        }
        return true;
    }

    public CSPDirective(@NonNull @Nonempty String string, @Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        this(string, abstractCSPSourceList == null ? null : abstractCSPSourceList.getAsString());
    }

    public CSPDirective(@NonNull @Nonempty String string, @Nullable String string2) {
        ValueEnforcer.isTrue((boolean)CSPDirective.isValidName(string), () -> "The CSP directive name '" + string + "' is invalid!");
        ValueEnforcer.isTrue((boolean)CSPDirective.isValidValue(string2), () -> "The CSP directive value '" + string2 + "' is invalid!");
        this.m_sName = string;
        this.m_sValue = string2;
    }

    @Override
    public final @NonNull @Nonempty String getName() {
        return this.m_sName;
    }

    @Override
    public final @Nullable String getValue() {
        return this.m_sValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSPDirective cSPDirective = (CSPDirective)object;
        return this.m_sName.equals(cSPDirective.m_sName) && EqualsHelper.equals((Object)this.m_sValue, (Object)cSPDirective.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sName).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Name", (Object)this.m_sName).appendIfNotNull("Value", (Object)this.m_sValue).getToString();
    }

    public static @NonNull CSPDirective createBaseURI(@Nullable String string) {
        return new CSPDirective("base-uri", string);
    }

    public static @NonNull CSPDirective createChildSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("child-src", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createConnectSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("connect-src", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createDefaultSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("default-src", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createFontSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("font-src", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createFormAction(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("form-action", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createFrameAncestors(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("frame-ancestors", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createFrameSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("frame-src", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createImgSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("img-src", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createManifestSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("manifest-src", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createMediaSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("media-src", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createObjectSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("object-src", abstractCSPSourceList);
    }

    @Deprecated(forRemoval=true, since="10.4.0")
    public static @NonNull CSPDirective createPrefetchSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("prefetch-src", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createReportURI(@Nullable String string) {
        return new CSPDirective("report-uri", string);
    }

    public static @NonNull CSPDirective createReportTo(@Nullable String string) {
        return new CSPDirective("report-to", string);
    }

    public static @NonNull CSPDirective createSandbox(@Nullable String string) {
        return new CSPDirective("sandbox", string);
    }

    public static @NonNull CSPDirective createScriptSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("script-src", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createScriptSrcAttr(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("script-src-attr", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createScriptSrcElem(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("script-src-elem", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createStyleSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("style-src", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createStyleSrcAttr(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("style-src-attr", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createStyleSrcElem(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("style-src-elem", abstractCSPSourceList);
    }

    public static @NonNull CSPDirective createWorkerSrc(@Nullable AbstractCSPSourceList<?> abstractCSPSourceList) {
        return new CSPDirective("worker-src", abstractCSPSourceList);
    }
}

