/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.csp;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.http.csp.ICSPDirective;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public abstract class AbstractCSPPolicy<T extends ICSPDirective> {
    private final ICommonsList<T> m_aList = new CommonsArrayList();

    public boolean isEmpty() {
        return this.m_aList.isEmpty();
    }

    public boolean isNotEmpty() {
        return this.m_aList.isNotEmpty();
    }

    @Nonnegative
    public int getDirectiveCount() {
        return this.m_aList.size();
    }

    public @NonNull AbstractCSPPolicy<T> addDirective(@NonNull T t) {
        ValueEnforcer.notNull(t, (String)"Directive");
        this.m_aList.add(t);
        return this;
    }

    public @NonNull EChange removeDirective(@Nullable T t) {
        return this.m_aList.removeObject(t);
    }

    public @NonNull EChange removeDirectiveAtIndex(int n) {
        return this.m_aList.removeAtIndex(n);
    }

    public @NonNull EChange removeAllDirectives() {
        return this.m_aList.removeAll();
    }

    public @NonNull String getAsString() {
        return StringImplode.getImplodedMappedNonEmpty((String)"; ", this.m_aList, ICSPDirective::getAsStringIfHasValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractCSPPolicy abstractCSPPolicy = (AbstractCSPPolicy)object;
        return this.m_aList.equals(abstractCSPPolicy.m_aList);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aList).getHashCode();
    }

    public @NonNull String toString() {
        return new ToStringGenerator((Object)this).append("list", this.m_aList).getToString();
    }
}

