/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.csp;

import com.helger.annotation.Nonempty;
import com.helger.base.name.IHasName;
import com.helger.base.string.StringHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ICSPDirective
extends IHasName {
    public @NonNull @Nonempty String getName();

    public @Nullable String getValue();

    default public boolean hasValue() {
        return StringHelper.isNotEmpty((String)this.getValue());
    }

    default public @NonNull @Nonempty String getAsString() {
        return StringHelper.getConcatenatedOnDemand((String)this.getName(), (char)' ', (String)this.getValue());
    }

    default public @Nullable String getAsStringIfHasValue() {
        String string = this.getValue();
        if (StringHelper.isNotEmpty((String)string)) {
            return this.getName() + " " + string;
        }
        return null;
    }
}

