/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.http.RFC7230Helper;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HttpForwardedHeaderHop {
    public static final String PARAM_FOR = "for";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_BY = "by";
    public static final String PARAM_PROTO = "proto";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpForwardedHeaderHop.class);
    private final ICommonsOrderedMap<String, String> m_aPairs = new CommonsLinkedHashMap();

    private static @NonNull String _getUnifiedToken(@NonNull String string) {
        return string.toLowerCase(Locale.ROOT);
    }

    public @NonNull HttpForwardedHeaderHop addPair(@Nonempty @NonNull String string, @NonNull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Token");
        ValueEnforcer.isTrue(() -> RFC7230Helper.isValidToken(string), (String)"Token is not valid according to RFC 7230");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        String string3 = HttpForwardedHeaderHop._getUnifiedToken(string);
        if (this.m_aPairs.containsKey((Object)string3)) {
            LOGGER.warn("Overwriting value of token '" + string3 + "'");
        }
        this.m_aPairs.put((Object)string3, (Object)string2);
        return this;
    }

    public @Nullable String getFirstValue(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Token");
        return (String)this.m_aPairs.get((Object)HttpForwardedHeaderHop._getUnifiedToken(string));
    }

    public boolean containsToken(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Token");
        return this.m_aPairs.containsKey((Object)HttpForwardedHeaderHop._getUnifiedToken(string));
    }

    public boolean containsFor() {
        return this.containsToken(PARAM_FOR);
    }

    public boolean containsHost() {
        return this.containsToken(PARAM_HOST);
    }

    public boolean containsBy() {
        return this.containsToken(PARAM_BY);
    }

    public boolean containsProto() {
        return this.containsToken(PARAM_PROTO);
    }

    public @Nullable EChange removePair(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Token");
        return this.m_aPairs.removeObject((Object)HttpForwardedHeaderHop._getUnifiedToken(string));
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<String> getAllTokens() {
        return this.m_aPairs.copyOfKeySet();
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedMap<String, String> getAllPairs() {
        return this.m_aPairs.getClone();
    }

    public @NonNull HttpForwardedHeaderHop removeAll() {
        this.m_aPairs.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.m_aPairs.isEmpty();
    }

    public boolean isNotEmpty() {
        return this.m_aPairs.isNotEmpty();
    }

    public int size() {
        return this.m_aPairs.size();
    }

    public @NonNull HttpForwardedHeaderHop setFor(@NonNull String string) {
        return this.addPair(PARAM_FOR, string);
    }

    public @Nullable String getFor() {
        return this.getFirstValue(PARAM_FOR);
    }

    public @NonNull HttpForwardedHeaderHop setHost(@NonNull String string) {
        return this.addPair(PARAM_HOST, string);
    }

    public @Nullable String getHost() {
        return this.getFirstValue(PARAM_HOST);
    }

    public @NonNull HttpForwardedHeaderHop setBy(@NonNull String string) {
        return this.addPair(PARAM_BY, string);
    }

    public @Nullable String getBy() {
        return this.getFirstValue(PARAM_BY);
    }

    public @NonNull HttpForwardedHeaderHop setProto(@NonNull String string) {
        return this.addPair(PARAM_PROTO, string);
    }

    public @Nullable String getProto() {
        return this.getFirstValue(PARAM_PROTO);
    }

    private static boolean _needsQuoting(@NonNull String string) {
        return !RFC7230Helper.isValidToken(string);
    }

    public @NonNull String getAsString() {
        if (this.m_aPairs.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry entry : this.m_aPairs.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(';');
            }
            stringBuilder.append(string).append('=');
            if (HttpForwardedHeaderHop._needsQuoting(string2)) {
                stringBuilder.append('\"');
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c == '\"' || c == '\\') {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                }
                stringBuilder.append('\"');
                continue;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        HttpForwardedHeaderHop httpForwardedHeaderHop = (HttpForwardedHeaderHop)object;
        return this.m_aPairs.equals(httpForwardedHeaderHop.m_aPairs);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aPairs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Pairs", this.m_aPairs).getToString();
    }
}

