/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.basicauth;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.http.basicauth.HttpBasicAuth;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class BasicAuthClientCredentials {
    private final String m_sUserName;
    private final String m_sPassword;

    public BasicAuthClientCredentials(@Nonempty @NonNull String string) {
        this(string, null);
    }

    public BasicAuthClientCredentials(@Nonempty @NonNull String string, @Nullable String string2) {
        this.m_sUserName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"UserName");
        this.m_sPassword = StringHelper.isEmpty((String)string2) ? null : string2;
    }

    @Nonempty
    public @NonNull String getUserName() {
        return this.m_sUserName;
    }

    public @Nullable String getPassword() {
        return this.m_sPassword;
    }

    public boolean hasPassword() {
        return this.m_sPassword != null;
    }

    @Nonempty
    public @NonNull String getRequestValue() {
        return HttpBasicAuth.getHttpHeaderValue(this.m_sUserName, this.m_sPassword);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BasicAuthClientCredentials basicAuthClientCredentials = (BasicAuthClientCredentials)object;
        return this.m_sUserName.equals(basicAuthClientCredentials.m_sUserName) && EqualsHelper.equals((Object)this.m_sPassword, (Object)basicAuthClientCredentials.m_sPassword);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sUserName).append((Object)this.m_sPassword).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("UserName", (Object)this.m_sUserName).appendPassword("Password").getToString();
    }
}

