/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.codec.RFC5234Helper;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nullable;
import java.util.BitSet;

@Immutable
public final class RFC7230Helper {
    private static final BitSet TOKEN_CHARS = new BitSet(256);

    private RFC7230Helper() {
    }

    public static boolean isValidTokenChar(char c) {
        return TOKEN_CHARS.get(c);
    }

    public static boolean isValidToken(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return RFC7230Helper.isValidToken(string.toCharArray());
    }

    public static boolean isValidToken(@Nullable char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return false;
        }
        for (char c : cArray) {
            if (RFC7230Helper.isValidTokenChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBackslash(char c) {
        return c == '\\';
    }

    static {
        for (int i = 0; i <= 127; ++i) {
            if (!RFC5234Helper.isDigit((int)i) && !RFC5234Helper.isAlpha((int)i)) continue;
            TOKEN_CHARS.set(i);
        }
        TOKEN_CHARS.set(33);
        TOKEN_CHARS.set(35);
        TOKEN_CHARS.set(36);
        TOKEN_CHARS.set(37);
        TOKEN_CHARS.set(38);
        TOKEN_CHARS.set(39);
        TOKEN_CHARS.set(42);
        TOKEN_CHARS.set(43);
        TOKEN_CHARS.set(45);
        TOKEN_CHARS.set(46);
        TOKEN_CHARS.set(94);
        TOKEN_CHARS.set(95);
        TOKEN_CHARS.set(96);
        TOKEN_CHARS.set(124);
        TOKEN_CHARS.set(126);
    }
}

