/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header.specific;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.header.AbstractQValueList;
import com.helger.http.header.QValue;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.function.Function;

public class AcceptLanguageList
extends AbstractQValueList<String> {
    @Nonnull
    private static String _unify(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    @Nonnull
    public AcceptLanguageList addLanguage(@Nonnull String string, @Nonnegative double d) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Language");
        this.qvalueMap().put((Object)AcceptLanguageList._unify(string), (Object)new QValue(d));
        return this;
    }

    @Nonnull
    public QValue getQValueOfLanguage(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Language");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptLanguageList._unify(string));
        if (qValue == null && (qValue = (QValue)this.qvalueMap().get((Object)"*")) == null) {
            return QValue.MIN_QVALUE;
        }
        return qValue;
    }

    public double getQualityOfLanguage(@Nonnull String string) {
        return this.getQValueOfLanguage(string).getQuality();
    }

    public boolean supportsLanguage(@Nonnull String string) {
        return this.getQValueOfLanguage(string).isAboveMinimumQuality();
    }

    public boolean explicitlySupportsLanguage(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Language");
        QValue qValue = (QValue)this.qvalueMap().get((Object)AcceptLanguageList._unify(string));
        return qValue != null && qValue.isAboveMinimumQuality();
    }

    @Override
    @Nonnull
    public String getAsHttpHeaderValue() {
        return this.getAsHttpHeaderValue(Function.identity());
    }
}

