/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.url;

import com.helger.annotation.RegEx;
import com.helger.base.string.StringHelper;
import com.helger.cache.regex.RegExHelper;
import jakarta.annotation.Nullable;

public final class URNHelper {
    @RegEx
    public static final String REGEX_URN = "^\\Qurn:\\E[a-zA-Z0-9][a-zA-Z0-9-]{0,31}\\Q:\\E[a-zA-Z0-9()+,\\-.:=@;$_!*'%/?#]+$";

    private URNHelper() {
    }

    public static boolean isValidURN(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return RegExHelper.stringMatchesPattern((String)REGEX_URN, (String)string);
    }
}

