/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.url;

import com.helger.base.codec.IEncoder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.url.URLCoder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;

public class URLParameterEncoder
implements IEncoder<String, String> {
    private final Charset m_aCharset;

    public URLParameterEncoder(@Nonnull Charset charset) {
        this.m_aCharset = (Charset)ValueEnforcer.notNull((Object)charset, (String)"Charset");
    }

    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nullable
    public String getEncoded(@Nullable String string) {
        return string == null ? null : URLCoder.urlEncode(string, this.m_aCharset);
    }
}

