/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.url;

import com.helger.base.codec.IDecoder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.url.URLCoder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;

public class URLParameterDecoder
implements IDecoder<String, String> {
    private final Charset m_aCharset;

    public URLParameterDecoder(@Nonnull Charset charset) {
        this.m_aCharset = (Charset)ValueEnforcer.notNull((Object)charset, (String)"Charset");
    }

    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nullable
    public String getDecoded(@Nullable String string) {
        return URLCoder.urlDecodeOrNull(string, this.m_aCharset);
    }
}

