/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.url;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.iface.IHasSize;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.http.url.ISimpleURL;
import com.helger.http.url.URLParameterList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public class URLData
implements ISimpleURL {
    public static final URLData EMPTY_URL_DATA = new URLData("");
    private final String m_sPath;
    private final URLParameterList m_aParams;
    private final String m_sAnchor;

    public URLData(@Nonnull String string) {
        this(string, null, null);
    }

    public URLData(@Nonnull String string, @Nullable URLParameterList uRLParameterList) {
        this(string, uRLParameterList, null);
    }

    public URLData(@Nonnull String string, @Nullable URLParameterList uRLParameterList, @Nullable String string2) {
        this.m_sPath = (String)ValueEnforcer.notNull((Object)string, (String)"Path");
        this.m_aParams = uRLParameterList != null ? uRLParameterList : new URLParameterList();
        this.m_sAnchor = string2;
    }

    @Override
    @Nonnull
    public final String getPath() {
        return this.m_sPath;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final URLParameterList params() {
        return this.m_aParams;
    }

    @Override
    @Nullable
    public final String getAnchor() {
        return this.m_sAnchor;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        URLData uRLData = (URLData)object;
        return this.m_sPath.equals(uRLData.m_sPath) && this.m_aParams.equals(uRLData.m_aParams) && EqualsHelper.equals((Object)this.m_sAnchor, (Object)uRLData.m_sAnchor);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sPath).append((Object)this.m_aParams).append((Object)this.m_sAnchor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Path", (Object)this.m_sPath).appendIf("Params", (Object)this.m_aParams, IHasSize::isNotEmpty).appendIfNotNull("Anchor", (Object)this.m_sAnchor).getToString();
    }
}

