/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http.header;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.CGlobal;
import com.helger.base.clone.ICloneable;
import com.helger.base.codec.impl.RFC2616Codec;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.iface.IHasSize;
import com.helger.base.state.EChange;
import com.helger.base.state.IClearable;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.web.PDTWebDateHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HttpHeaderMap
implements IHasSize,
ICommonsIterable<Map.Entry<String, ICommonsList<String>>>,
ICloneable<HttpHeaderMap>,
IClearable {
    public static final String SEPARATOR_KEY_VALUE = ": ";
    public static final boolean DEFAULT_QUOTE_IF_NECESSARY = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHeaderMap.class);
    private final ICommonsOrderedMap<String, ICommonsList<String>> m_aHeaders = new CommonsLinkedHashMap();

    public HttpHeaderMap() {
    }

    public HttpHeaderMap(@Nonnull HttpHeaderMap httpHeaderMap) {
        ValueEnforcer.notNull((Object)httpHeaderMap, (String)"Other");
        this.m_aHeaders.putAll(httpHeaderMap.m_aHeaders);
    }

    @Nonnull
    public static String getUnifiedValue(@Nullable String string) {
        return HttpHeaderMap.getUnifiedValue(string, false);
    }

    @Nonnull
    public static String getUnifiedValue(@Nullable String string, boolean bl) {
        char[] cArray;
        char[] cArray2;
        int n = 0;
        if (StringHelper.isNotEmpty((String)string)) {
            cArray2 = new char[string.length()];
            boolean bl2 = false;
            for (char c : string.toCharArray()) {
                if (Character.isWhitespace(c)) {
                    if (c == '\r' || c == '\n' || c == '\t') {
                        if (!bl2) {
                            cArray2[n++] = 32;
                        }
                    } else {
                        cArray2[n++] = c;
                    }
                    bl2 = true;
                    continue;
                }
                cArray2[n++] = c;
                bl2 = false;
            }
        } else {
            cArray2 = CGlobal.EMPTY_CHAR_ARRAY;
        }
        if (bl) {
            if (RFC2616Codec.isToken((char[])cArray2) || RFC2616Codec.isMaybeEncoded((char[])cArray2)) {
                cArray = cArray2;
            } else {
                cArray = new RFC2616Codec().getEncoded(cArray2, 0, n);
                n = cArray.length;
            }
        } else {
            cArray = cArray2;
        }
        String string2 = new String(cArray, 0, n);
        if (LOGGER.isDebugEnabled() && !EqualsHelper.equals((Object)string, (Object)string2)) {
            LOGGER.debug("getUnifiedValue('" + string + "'," + bl + ") resulted in '" + string2 + "'");
        }
        return string2;
    }

    @Nonnull
    public EChange removeAll() {
        return this.m_aHeaders.removeAll();
    }

    @Nullable
    @ReturnsMutableObject
    private Map.Entry<String, ICommonsList<String>> _getHeaderEntryCaseInsensitive(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (Map.Entry entry : this.m_aHeaders.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(string)) continue;
                return entry;
            }
        }
        return null;
    }

    @Nullable
    @ReturnsMutableObject
    private ICommonsList<String> _getHeaderListCaseInsensitive(@Nullable String string) {
        Map.Entry<String, ICommonsList<String>> entry = this._getHeaderEntryCaseInsensitive(string);
        return entry == null ? null : entry.getValue();
    }

    @Nonnull
    @ReturnsMutableObject
    private ICommonsList<String> _getOrCreateHeaderList(@Nonnull @Nonempty String string) {
        CommonsArrayList commonsArrayList = this._getHeaderListCaseInsensitive(string);
        if (commonsArrayList == null) {
            commonsArrayList = new CommonsArrayList(2);
            this.m_aHeaders.put((Object)string, (Object)commonsArrayList);
        }
        return commonsArrayList;
    }

    @Nonnull
    private EChange _setHeader(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Setting HTTP header: '" + string + "' = '" + string2 + "'");
        }
        return this._getOrCreateHeaderList(string).set((Object)string2);
    }

    @Nonnull
    private EChange _addHeader(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Adding HTTP header: '" + string + "' = '" + string2 + "'");
        }
        return this._getOrCreateHeaderList(string).addObject((Object)string2);
    }

    public void setHeader(@Nonnull @Nonempty String string, @Nullable String string2) {
        if (string2 != null) {
            this._setHeader(string, string2);
        }
    }

    public void addHeader(@Nonnull @Nonempty String string, @Nullable String string2) {
        if (string2 != null) {
            this._addHeader(string, string2);
        }
    }

    @Nonnull
    public static String getDateTimeAsString(@Nonnull ZonedDateTime zonedDateTime) {
        ValueEnforcer.notNull((Object)zonedDateTime, (String)"DateTime");
        return PDTWebDateHelper.getAsStringRFC822((ZonedDateTime)zonedDateTime);
    }

    @Nonnull
    public static String getDateTimeAsString(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"DateTime");
        return PDTWebDateHelper.getAsStringRFC822((LocalDateTime)localDateTime);
    }

    public void setDateHeader(@Nonnull @Nonempty String string, long l) {
        this.setDateHeader(string, PDTFactory.createZonedDateTime((long)l));
    }

    public void setDateHeader(@Nonnull @Nonempty String string, @Nonnull LocalDate localDate) {
        this.setDateHeader(string, PDTFactory.createZonedDateTime((LocalDate)localDate));
    }

    public void setDateHeader(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime) {
        this.setDateHeader(string, PDTFactory.createZonedDateTime((LocalDateTime)localDateTime));
    }

    public void setDateHeader(@Nonnull @Nonempty String string, @Nonnull ZonedDateTime zonedDateTime) {
        this._setHeader(string, HttpHeaderMap.getDateTimeAsString(zonedDateTime));
    }

    public void addDateHeader(@Nonnull @Nonempty String string, long l) {
        this.addDateHeader(string, PDTFactory.createZonedDateTime((long)l));
    }

    public void addDateHeader(@Nonnull @Nonempty String string, @Nonnull LocalDate localDate) {
        this.addDateHeader(string, PDTFactory.createZonedDateTime((LocalDate)localDate));
    }

    public void addDateHeader(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime) {
        this.addDateHeader(string, PDTFactory.createZonedDateTime((LocalDateTime)localDateTime));
    }

    public void addDateHeader(@Nonnull @Nonempty String string, @Nonnull ZonedDateTime zonedDateTime) {
        this._addHeader(string, HttpHeaderMap.getDateTimeAsString(zonedDateTime));
    }

    public void setIntHeader(@Nonnull @Nonempty String string, int n) {
        this._setHeader(string, Integer.toString(n));
    }

    public void addIntHeader(@Nonnull @Nonempty String string, int n) {
        this._addHeader(string, Integer.toString(n));
    }

    public void setLongHeader(@Nonnull @Nonempty String string, long l) {
        this._setHeader(string, Long.toString(l));
    }

    public void addLongHeader(@Nonnull @Nonempty String string, long l) {
        this._addHeader(string, Long.toString(l));
    }

    public void setAllHeaders(@Nonnull HttpHeaderMap httpHeaderMap) {
        ValueEnforcer.notNull((Object)httpHeaderMap, (String)"Other");
        for (Map.Entry entry : httpHeaderMap.m_aHeaders.entrySet()) {
            String string = (String)entry.getKey();
            this.removeHeaders(string);
            for (String string2 : (ICommonsList)entry.getValue()) {
                this.addHeader(string, string2);
            }
        }
    }

    public void addAllHeaders(@Nonnull HttpHeaderMap httpHeaderMap) {
        ValueEnforcer.notNull((Object)httpHeaderMap, (String)"Other");
        for (Map.Entry entry : httpHeaderMap.m_aHeaders.entrySet()) {
            String string = (String)entry.getKey();
            for (String string2 : (ICommonsList)entry.getValue()) {
                this.addHeader(string, string2);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, ICommonsList<String>> getAllHeaders() {
        return this.m_aHeaders.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllHeaderNames() {
        return this.m_aHeaders.copyOfKeySet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllHeaderValues(@Nullable String string) {
        ICommonsList<String> iCommonsList;
        if (StringHelper.isNotEmpty((String)string) && (iCommonsList = this._getHeaderListCaseInsensitive(string)) != null) {
            return (ICommonsList)iCommonsList.getClone();
        }
        return new CommonsArrayList();
    }

    @Nullable
    public String getFirstHeaderValue(@Nullable String string) {
        ICommonsList<String> iCommonsList;
        if (StringHelper.isNotEmpty((String)string) && (iCommonsList = this._getHeaderListCaseInsensitive(string)) != null) {
            return (String)iCommonsList.getFirstOrNull();
        }
        return null;
    }

    @Nullable
    public String getHeaderCombined(@Nullable String string, @Nonnull String string2) {
        ICommonsList<String> iCommonsList;
        if (StringHelper.isNotEmpty((String)string) && (iCommonsList = this._getHeaderListCaseInsensitive(string)) != null) {
            return StringImplode.getImploded((String)string2, iCommonsList);
        }
        return null;
    }

    public boolean containsHeaders(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return this._getHeaderListCaseInsensitive(string) != null;
    }

    @Nonnull
    public EChange removeHeadersIf(@Nonnull Predicate<? super String> predicate) {
        return this.m_aHeaders.removeIfKey(predicate);
    }

    @Nonnull
    public EChange removeHeaders(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return EChange.UNCHANGED;
        }
        Map.Entry<String, ICommonsList<String>> entry = this._getHeaderEntryCaseInsensitive(string);
        if (entry != null) {
            return this.m_aHeaders.removeObject((Object)entry.getKey());
        }
        return EChange.UNCHANGED;
    }

    @Nonnull
    public EChange removeHeader(@Nullable String string, @Nullable String string2) {
        boolean bl;
        Map.Entry<String, ICommonsList<String>> entry = this._getHeaderEntryCaseInsensitive(string);
        boolean bl2 = bl = entry != null && entry.getValue().remove((Object)string2);
        if (bl && entry.getValue().isEmpty()) {
            this.m_aHeaders.remove((Object)entry.getKey());
        }
        return EChange.valueOf((boolean)bl);
    }

    @Nonnull
    public Iterator<Map.Entry<String, ICommonsList<String>>> iterator() {
        return this.m_aHeaders.entrySet().iterator();
    }

    @Nonnegative
    public int size() {
        return this.m_aHeaders.size();
    }

    public boolean isEmpty() {
        return this.m_aHeaders.isEmpty();
    }

    public void forEachSingleHeader(@Nonnull BiConsumer<? super String, ? super String> biConsumer, boolean bl) {
        this.forEachSingleHeader(biConsumer, bl, false);
    }

    public void forEachSingleHeader(@Nonnull BiConsumer<? super String, ? super String> biConsumer, boolean bl, boolean bl2) {
        for (Map.Entry entry : this.m_aHeaders.entrySet()) {
            String string = (String)entry.getKey();
            for (String string2 : (ICommonsList)entry.getValue()) {
                String string3 = bl ? HttpHeaderMap.getUnifiedValue(string2, bl2) : string2;
                biConsumer.accept(string, string3);
            }
        }
    }

    public void forEachHeaderLine(@Nonnull Consumer<? super String> consumer, boolean bl) {
        this.forEachHeaderLine(consumer, bl, false);
    }

    public void forEachHeaderLine(@Nonnull Consumer<? super String> consumer, boolean bl, boolean bl2) {
        for (Map.Entry entry : this.m_aHeaders.entrySet()) {
            String string = (String)entry.getKey();
            for (String string2 : (ICommonsList)entry.getValue()) {
                String string3 = string + SEPARATOR_KEY_VALUE + (bl ? HttpHeaderMap.getUnifiedValue(string2, bl2) : string2);
                consumer.accept(string3);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllHeaderLines(boolean bl) {
        return this.getAllHeaderLines(bl, false);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllHeaderLines(boolean bl, boolean bl2) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.forEachHeaderLine(arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0), bl, bl2);
        return commonsArrayList;
    }

    public void setContentLength(long l) {
        this._setHeader("Content-Length", Long.toString(l));
    }

    public void setContentType(@Nonnull String string) {
        this._setHeader("Content-Type", string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public HttpHeaderMap getClone() {
        return new HttpHeaderMap(this);
    }

    @Nonnull
    public Map<String, List<String>> getAsMapStringToListString() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        this.forEachSingleHeader((string2, string3) -> hashMap.computeIfAbsent((String)string2, string -> new ArrayList()).add(string3), false, false);
        return hashMap;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        HttpHeaderMap httpHeaderMap = (HttpHeaderMap)object;
        return this.m_aHeaders.equals(httpHeaderMap.m_aHeaders);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aHeaders).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Headers", this.m_aHeaders).getToString();
    }
}

