/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.impl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.graph.IMutableBaseGraphObject;
import com.helger.graph.impl.GraphObjectIDFactory;
import com.helger.typeconvert.collection.AttributeContainerAny;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public abstract class AbstractBaseGraphObject
implements IMutableBaseGraphObject {
    private final String m_sID;
    private final AttributeContainerAny<String> m_aAttrs = new AttributeContainerAny();

    protected AbstractBaseGraphObject(@Nullable String string) {
        this.m_sID = StringHelper.isEmpty((String)string) ? GraphObjectIDFactory.createNewGraphObjectID() : string;
    }

    public final @NonNull @Nonempty String getID() {
        return this.m_sID;
    }

    @ReturnsMutableObject
    public final @NonNull AttributeContainerAny<String> attrs() {
        return this.m_aAttrs;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractBaseGraphObject abstractBaseGraphObject = (AbstractBaseGraphObject)object;
        return this.m_sID.equals(abstractBaseGraphObject.m_sID) && this.m_aAttrs.equals(abstractBaseGraphObject.m_aAttrs);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append(this.m_aAttrs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("Attrs", this.m_aAttrs).getToString();
    }
}

