/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.error.list;

import com.helger.annotation.Nonempty;
import com.helger.annotation.RegEx;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.IHasErrorField;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.level.IHasErrorLevel;
import com.helger.diagnostics.error.level.IHasErrorLevels;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@MustImplementEqualsAndHashcode
public interface IErrorList
extends ICommonsList<IError>,
IHasErrorLevels<IError> {
    default public boolean hasNoEntryForField(@Nullable String string) {
        return this.containsNone(iError -> iError.hasErrorFieldName(string));
    }

    default public boolean hasNoEntryForFields(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!this.hasEntryForField(string)) continue;
                return false;
            }
        }
        return true;
    }

    default public boolean hasEntryForField(@Nullable String string) {
        return this.containsAny(iError -> iError.hasErrorFieldName(string));
    }

    default public boolean hasEntryForField(@Nullable String string, @Nullable IErrorLevel iErrorLevel) {
        return iErrorLevel != null && this.containsAny(iError -> iError.hasErrorFieldName(string) && iError.hasErrorLevel(iErrorLevel));
    }

    default public boolean hasErrorForField(@Nullable String string) {
        return this.containsAny(iError -> iError.hasErrorFieldName(string) && iError.isError());
    }

    default public boolean hasEntryForFields(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!this.hasEntryForField(string)) continue;
                return true;
            }
        }
        return false;
    }

    @ReturnsMutableCopy
    default public @NonNull IErrorList getListOfField(@Nullable String string) {
        return this.getSubList(iError -> iError.hasErrorFieldName(string));
    }

    @ReturnsMutableCopy
    default public @NonNull IErrorList getListOfFields(String ... stringArray) {
        if (ArrayHelper.isEmpty((Object[])stringArray)) {
            return this.getSubList(iError -> false);
        }
        return this.getSubList(iError -> iError.hasErrorFieldName() && ArrayHelper.contains((Object[])stringArray, (Object)iError.getErrorFieldName()));
    }

    @ReturnsMutableCopy
    default public @NonNull IErrorList getListOfFields(@Nullable Collection<String> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return this.getSubList(iError -> false);
        }
        return this.getSubList(iError -> iError.hasErrorFieldName() && collection.contains(iError.getErrorFieldName()));
    }

    @ReturnsMutableCopy
    default public @NonNull IErrorList getListOfFieldsStartingWith(String ... stringArray) {
        if (ArrayHelper.isEmpty((Object[])stringArray)) {
            return this.getSubList(iError -> false);
        }
        return this.getSubList(iError -> iError.hasErrorFieldName() && ArrayHelper.containsAny((Object[])stringArray, string -> iError.getErrorFieldName().startsWith((String)string)));
    }

    @ReturnsMutableCopy
    default public @NonNull IErrorList getListOfFieldsRegExp(@RegEx @NonNull @Nonempty String string) {
        return this.getSubList(iError -> iError.hasErrorFieldName() && RegExHelper.stringMatchesPattern((String)string, (String)iError.getErrorFieldName()));
    }

    @ReturnsMutableCopy
    default public @NonNull IErrorList getListWithoutField() {
        return this.getSubList(IHasErrorField::hasNoErrorFieldName);
    }

    default public @NonNull IErrorList getAllFailures() {
        return this.getSubList(IHasErrorLevel::isFailure);
    }

    default public @NonNull IErrorList getAllErrors() {
        return this.getSubList(IHasErrorLevel::isError);
    }

    @ReturnsMutableCopy
    public @NonNull IErrorList getSubList(@Nullable Predicate<? super IError> var1);

    @ReturnsMutableCopy
    default public @NonNull ICommonsList<String> getAllTexts(@NonNull Locale locale) {
        return this.getAllDataItems(iError -> iError.getErrorText(locale));
    }

    @ReturnsMutableCopy
    default public <T> @NonNull ICommonsList<T> getAllDataItems(@NonNull Function<? super IError, ? extends T> function) {
        return new CommonsArrayList((Collection)((Object)this), function);
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsMap<String, ICommonsList<IError>> getGroupedByID() {
        return this.getGrouped(IError::getErrorID);
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsMap<String, ICommonsList<IError>> getGroupedByFieldName() {
        return this.getGrouped(IError::getErrorFieldName);
    }

    @ReturnsMutableCopy
    default public <T> @NonNull ICommonsOrderedMap<T, ICommonsList<IError>> getGrouped(@NonNull Function<? super IError, T> function) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        this.forEach(arg_0 -> IErrorList.lambda$getGrouped$15((ICommonsOrderedMap)commonsLinkedHashMap, function, arg_0));
        return commonsLinkedHashMap;
    }

    private static /* synthetic */ void lambda$getGrouped$15(ICommonsOrderedMap iCommonsOrderedMap, Function function, IError iError) {
        ((ICommonsList)iCommonsOrderedMap.computeIfAbsent(function.apply(iError), object -> new CommonsArrayList())).add((Object)iError);
    }
}

