/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.error;

import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.location.ILocation;
import com.helger.base.location.SimpleLocation;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.SingleError;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.text.ConstantHasErrorText;
import com.helger.diagnostics.error.text.DynamicHasErrorText;
import com.helger.diagnostics.error.text.IHasErrorText;
import com.helger.text.IHasText;
import com.helger.text.IMultilingualText;
import java.time.LocalDateTime;
import javax.xml.stream.Location;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public abstract class AbstractSingleErrorBuilder<ERRTYPE extends SingleError, IMPLTYPE extends AbstractSingleErrorBuilder<ERRTYPE, IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE>,
IBuilder<ERRTYPE> {
    public static final IErrorLevel DEFAULT_ERROR_LEVEL = EErrorLevel.ERROR;
    protected LocalDateTime m_aErrorDT;
    protected IErrorLevel m_aErrorLevel = DEFAULT_ERROR_LEVEL;
    protected String m_sErrorID;
    protected String m_sErrorFieldName;
    protected ILocation m_aErrorLocation;
    protected IHasErrorText m_aErrorText;
    protected Throwable m_aLinkedException;

    protected AbstractSingleErrorBuilder() {
    }

    protected AbstractSingleErrorBuilder(@NonNull IError iError) {
        ValueEnforcer.notNull((Object)iError, (String)"Error");
        this.errorLevel(iError.getErrorLevel());
        this.errorID(iError.getErrorID());
        this.errorFieldName(iError.getErrorFieldName());
        this.errorLocation(iError.getErrorLocation());
        this.errorText(iError.getErrorTexts());
        this.linkedException(iError.getLinkedException());
    }

    public final @NonNull IMPLTYPE dateTime(@Nullable LocalDateTime localDateTime) {
        this.m_aErrorDT = localDateTime;
        return (IMPLTYPE)((AbstractSingleErrorBuilder)this.thisAsT());
    }

    public final @NonNull IMPLTYPE errorLevel(@NonNull IErrorLevel iErrorLevel) {
        ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
        this.m_aErrorLevel = iErrorLevel;
        return (IMPLTYPE)((AbstractSingleErrorBuilder)this.thisAsT());
    }

    public final @NonNull IMPLTYPE errorID(@Nullable String string) {
        this.m_sErrorID = string;
        return (IMPLTYPE)((AbstractSingleErrorBuilder)this.thisAsT());
    }

    public final @NonNull IMPLTYPE errorFieldName(@Nullable String string) {
        this.m_sErrorFieldName = string;
        return (IMPLTYPE)((AbstractSingleErrorBuilder)this.thisAsT());
    }

    public final @NonNull IMPLTYPE errorLocation(@Nullable String string) {
        return this.errorLocation((ILocation)new SimpleLocation(string));
    }

    public final @NonNull IMPLTYPE errorLocation(@Nullable Locator locator) {
        return this.errorLocation((ILocation)SimpleLocation.create((Locator)locator));
    }

    public final @NonNull IMPLTYPE errorLocation(@Nullable SAXParseException sAXParseException) {
        return this.errorLocation((ILocation)SimpleLocation.create((SAXParseException)sAXParseException));
    }

    public final @NonNull IMPLTYPE errorLocation(@Nullable Location location) {
        return this.errorLocation((ILocation)SimpleLocation.create((Location)location));
    }

    public final @NonNull IMPLTYPE errorLocation(@Nullable ILocation iLocation) {
        this.m_aErrorLocation = iLocation;
        return (IMPLTYPE)((AbstractSingleErrorBuilder)this.thisAsT());
    }

    public final @NonNull IMPLTYPE errorText(@Nullable String string) {
        return this.errorText(ConstantHasErrorText.createOnDemand(string));
    }

    public final @NonNull IMPLTYPE errorText(@Nullable IMultilingualText iMultilingualText) {
        this.m_aErrorText = iMultilingualText == null ? null : (iMultilingualText.texts().size() == 1 ? ConstantHasErrorText.createOnDemand((String)iMultilingualText.texts().getFirstValue()) : new DynamicHasErrorText((IHasText)iMultilingualText));
        return (IMPLTYPE)((AbstractSingleErrorBuilder)this.thisAsT());
    }

    public final @NonNull IMPLTYPE errorText(@Nullable IHasErrorText iHasErrorText) {
        this.m_aErrorText = iHasErrorText;
        return (IMPLTYPE)((AbstractSingleErrorBuilder)this.thisAsT());
    }

    public final @NonNull IMPLTYPE linkedException(@Nullable Throwable throwable) {
        this.m_aLinkedException = throwable;
        return (IMPLTYPE)((AbstractSingleErrorBuilder)this.thisAsT());
    }
}

