/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.callback.exception;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.callback.exception.IExceptionCallback;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.mock.exception.IMockException;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.diagnostics.error.level.IHasErrorLevel;
import com.helger.diagnostics.log.LogHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LoggingExceptionCallback
implements IExceptionCallback<Throwable>,
IHasErrorLevel {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingExceptionCallback.class);
    private IErrorLevel m_aErrorLevel = EErrorLevel.ERROR;

    @Override
    public @NonNull IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    public final @NonNull LoggingExceptionCallback setErrorLevel(@NonNull IErrorLevel iErrorLevel) {
        this.m_aErrorLevel = (IErrorLevel)ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
        return this;
    }

    @Nonempty
    @OverrideOnDemand
    protected @NonNull @Nonempty String getLogMessage(@Nullable Throwable throwable) {
        if (throwable == null) {
            return "An error occurred";
        }
        return "An exception was thrown";
    }

    @OverrideOnDemand
    protected boolean isLogException(@Nullable Throwable throwable) {
        return !(throwable instanceof IMockException);
    }

    public void onException(@Nullable Throwable throwable) {
        String string = this.getLogMessage(throwable);
        boolean bl = this.isLogException(throwable);
        LogHelper.log(LOGGER, this.m_aErrorLevel, string, bl ? throwable : null);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

