/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diagnostics.error.level;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.level.IErrorLevel;
import org.jspecify.annotations.NonNull;

@Immutable
public class ErrorLevel
implements IErrorLevel {
    private final String m_sID;
    private final int m_nNumericLevel;

    public ErrorLevel(@NonNull @Nonempty String string, @Nonnegative int n) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.m_nNumericLevel = n;
    }

    public @NonNull @Nonempty String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnegative
    public int getNumericLevel() {
        return this.m_nNumericLevel;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ErrorLevel errorLevel = (ErrorLevel)object;
        return this.m_sID.equals(errorLevel.m_sID) && this.m_nNumericLevel == errorLevel.m_nNumericLevel;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).append(this.m_nNumericLevel).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("numericLevel", this.m_nNumericLevel).getToString();
    }
}

